/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.tea.core.TaskingEngine;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.internal.config.PropertyConfigurationStore;
import org.eclipse.tea.core.services.TaskingHeadlessLifeCycle;
import org.eclipse.tea.core.services.TaskingLog;

public class TaskingEngineApplication
implements IApplication {
    public static final Integer EXIT_FAILED = new Integer(1);
    public static final Integer EXIT_EXCEPTION = new Integer(2);

    public Object start(IApplicationContext context) throws Exception {
        String argPropertiesFile = null;
        String argTaskChain = null;
        String[] args = (String[])context.getArguments().get("application.args");
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if ("-properties".equals(arg) || "-configuration".equals(arg)) {
                argPropertiesFile = args[i + 1];
            }
            if ("-taskchain".equals(arg) || "-execute".equals(arg)) {
                argTaskChain = args[i + 1];
            }
            ++i;
        }
        File propFile = null;
        if (argPropertiesFile != null && !(propFile = new File(argPropertiesFile)).exists()) {
            throw new RuntimeException("configuration file does not exist: " + propFile);
        }
        IEclipseContext rootContext = TaskingInjectionHelper.getRootContext();
        rootContext.set("org.eclipse.tea.core.headless", (Object)true);
        TaskingEngine engine = TaskingEngine.withConfiguration(this.getPreferenceStore(propFile));
        LifeCycleHelper helper = new LifeCycleHelper();
        boolean restart = (Boolean)ContextInjectionFactory.invoke((Object)helper, TaskingHeadlessLifeCycle.HeadlessStartup.class, (IEclipseContext)engine.getContext());
        if (restart) {
            return EXIT_RESTART;
        }
        try {
            if (Strings.isNullOrEmpty((String)argTaskChain)) {
                throw new RuntimeException("Nothing to do. Use the -execute argument.");
            }
            IStatus status = engine.runTaskChain(TaskingInjectionHelper.createNewChainContext(engine, argTaskChain, null));
            if (status.getSeverity() >= 4) {
                Integer n = EXIT_FAILED;
                return n;
            }
        }
        catch (Exception e) {
            ((TaskingLog)engine.getContext().get(TaskingLog.class)).debug("Failed to run tasking", e);
            Integer n = EXIT_EXCEPTION;
            return n;
        }
        finally {
            ContextInjectionFactory.invoke((Object)helper, TaskingHeadlessLifeCycle.HeadlessShutdown.class, (IEclipseContext)engine.getContext());
        }
        return EXIT_OK;
    }

    protected TaskingConfigurationStore getPreferenceStore(File propFile) throws IOException {
        return new PropertyConfigurationStore(propFile);
    }

    public void stop() {
    }

    private static final class LifeCycleHelper {
        private LifeCycleHelper() {
        }

        @TaskingHeadlessLifeCycle.HeadlessStartup
        public boolean checkStartup(TaskingLog log, IEclipseContext context, @Service List<TaskingHeadlessLifeCycle> contributions) {
            for (TaskingHeadlessLifeCycle contrib : new TreeSet<TaskingHeadlessLifeCycle>(contributions)) {
                try {
                    TaskingHeadlessLifeCycle.StartupAction action = (TaskingHeadlessLifeCycle.StartupAction)((Object)ContextInjectionFactory.invoke((Object)contrib, TaskingHeadlessLifeCycle.HeadlessStartup.class, (IEclipseContext)context, (Object)((Object)TaskingHeadlessLifeCycle.StartupAction.CONTINUE)));
                    if (action != TaskingHeadlessLifeCycle.StartupAction.RESTART) continue;
                    return true;
                }
                catch (Exception e) {
                    log.error("Failure in contribution @HeadlessStartup " + contrib.getClass().getName(), e);
                    throw e;
                }
            }
            return false;
        }

        @TaskingHeadlessLifeCycle.HeadlessShutdown
        public void checkShutdown(TaskingLog log, IEclipseContext context, @Service List<TaskingHeadlessLifeCycle> contributions) {
            for (TaskingHeadlessLifeCycle contrib : new TreeSet<TaskingHeadlessLifeCycle>(contributions)) {
                try {
                    ContextInjectionFactory.invoke((Object)contrib, TaskingHeadlessLifeCycle.HeadlessShutdown.class, (IEclipseContext)context, null);
                }
                catch (Exception e) {
                    log.error("Failure in contribution @HeadlessShutdown " + contrib.getClass().getName(), e);
                }
            }
            log.debug("Shutdown contributions done.");
        }
    }
}

