/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.model.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tea.core.internal.model.iface.TaskingContainer;
import org.eclipse.tea.core.internal.model.iface.TaskingElement;
import org.eclipse.tea.core.internal.model.iface.TaskingItem;
import org.eclipse.tea.core.internal.model.impl.GroupingNode;
import org.eclipse.tea.core.services.TaskingMenuDecoration;
import org.osgi.framework.FrameworkUtil;

public class TaskingContainerImpl
implements TaskingContainer {
    private final String[] path;
    private Field decoration;
    private final Map<String, TaskingMenuDecoration.TaskingMenuGroupingId> definedGroupingIds = new TreeMap<String, TaskingMenuDecoration.TaskingMenuGroupingId>();
    private final Set<TaskingElement> children = new HashSet<TaskingElement>();
    private final String dummy;

    public TaskingContainerImpl(String[] path) {
        this.dummy = null;
        this.path = path;
    }

    public void setDecoration(Field decoration) {
        this.decoration = decoration;
    }

    public void addGroupingId(Field groupingId) {
        TaskingMenuDecoration.TaskingMenuGroupingId annotation = groupingId.getAnnotation(TaskingMenuDecoration.TaskingMenuGroupingId.class);
        try {
            this.definedGroupingIds.put(groupingId.get(null).toString(), annotation);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected Error", e);
        }
    }

    @Override
    public String getIconBundle() {
        if (this.decoration == null) {
            return null;
        }
        return FrameworkUtil.getBundle(this.decoration.getDeclaringClass()).getSymbolicName();
    }

    @Override
    public String getIconPath() {
        if (this.decoration == null) {
            return null;
        }
        try {
            return this.decoration.get(null).toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected Error", e);
        }
    }

    @Override
    public String getLabel() {
        return this.path[this.path.length - 1];
    }

    @Override
    public Set<TaskingElement> getChildren() {
        if (this.children.isEmpty()) {
            return this.children;
        }
        TreeMap allNodes = new TreeMap();
        this.children.stream().map(c -> c.getGroupingId()).forEach(id -> {
            GroupingNode groupingNode = this.getGroupingNode((String)id, allNodes);
        });
        GroupingNode rootNode = (GroupingNode)allNodes.get("none");
        Assert.isNotNull((Object)rootNode, (String)"No root grouping node");
        final List<String> sortedGroupingIds = rootNode.flatListSorted();
        TreeSet<TaskingElement> sortedElements = new TreeSet<TaskingElement>(new Comparator<TaskingElement>(){

            @Override
            public int compare(TaskingElement a, TaskingElement b) {
                int groupingIndexB;
                int groupingIndexA = sortedGroupingIds.indexOf(a.getGroupingId());
                int x = Integer.compare(groupingIndexA, groupingIndexB = sortedGroupingIds.indexOf(b.getGroupingId()));
                if (x != 0) {
                    return x;
                }
                return a.getLabel().compareTo(b.getLabel());
            }
        });
        sortedElements.addAll(this.children);
        return sortedElements;
    }

    private GroupingNode getGroupingNode(String id, Map<String, GroupingNode> allNodes) {
        return allNodes.computeIfAbsent(id, key -> {
            GroupingNode node = new GroupingNode((String)key);
            if (key.equals("none")) {
                return node;
            }
            TaskingMenuDecoration.TaskingMenuGroupingId defined = this.definedGroupingIds.get(key);
            if (defined == null) {
                this.getGroupingNode((String)"none", (Map<String, GroupingNode>)map).after.add(node);
            } else if (!Strings.isNullOrEmpty((String)defined.afterGroupingId())) {
                this.getGroupingNode((String)defined.afterGroupingId(), (Map<String, GroupingNode>)map).after.add(node);
            } else {
                this.getGroupingNode((String)defined.beforeGroupingId(), (Map<String, GroupingNode>)map).before.add(node);
            }
            return node;
        });
    }

    @Override
    public TaskingContainer getContainer(String name) {
        for (TaskingElement e : this.children) {
            if (!(e instanceof TaskingContainer) || !e.getLabel().equals(name)) continue;
            return (TaskingContainer)e;
        }
        return null;
    }

    @Override
    public boolean isDevelopment() {
        boolean dev = true;
        for (TaskingElement e : this.children) {
            if (e.isDevelopment()) continue;
            dev = false;
        }
        return dev;
    }

    @Override
    public String getGroupingId() {
        if (this.decoration == null) {
            return "none";
        }
        return this.decoration.getAnnotation(TaskingMenuDecoration.TaskingMenuPathDecoration.class).groupingId();
    }

    @Override
    public TaskingItem getItem(String id) {
        ArrayList<TaskingItem> matches = new ArrayList<TaskingItem>();
        for (TaskingElement ele : this.children) {
            TaskingItem result;
            if (ele instanceof TaskingItem && ((TaskingItem)ele).matchesId(id)) {
                matches.add((TaskingItem)ele);
            }
            if (!(ele instanceof TaskingContainer) || (result = ((TaskingContainer)ele).getItem(id)) == null) continue;
            matches.add(result);
        }
        switch (matches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (TaskingItem)matches.get(0);
            }
        }
        throw new IllegalStateException("Ambiguous TaskChain ID: " + id + ". Matches " + Joiner.on((String)", ").join((Iterable)matches.stream().map(c -> c.getChain().getClass().getName()).collect(Collectors.toList())));
    }

    TaskingContainerImpl createGroup(String[] path, int lvl) {
        if (path.length <= lvl) {
            return this;
        }
        String toLookup = path[lvl];
        TaskingContainerImpl group = (TaskingContainerImpl)this.getContainer(toLookup);
        if (group == null) {
            String[] relPath = new String[lvl + 1];
            System.arraycopy(path, 0, relPath, 0, lvl + 1);
            group = new TaskingContainerImpl(relPath);
            this.addChild(group);
        }
        if (path.length - 1 == lvl) {
            return group;
        }
        return group.createGroup(path, lvl + 1);
    }

    void addChild(TaskingElement e) {
        this.children.add(e);
    }

    void debugString(StringBuilder target, String indent) {
        target.append(indent).append("Group '").append(this.getLabel()).append("'\n");
        indent = String.valueOf(indent) + "  ";
        for (TaskingElement element : this.children) {
            if (element instanceof TaskingContainerImpl) {
                ((TaskingContainerImpl)element).debugString(target, indent);
                continue;
            }
            target.append(indent).append("Item '").append(element).append("'\n");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.debugString(builder, "");
        return builder.toString();
    }
}

