/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.lcdsl.tasks.p2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.AbstractProductBuild;
import org.eclipse.tea.library.build.tasks.jar.TaskInitJarCache;
import org.eclipse.tea.library.build.tasks.p2.UpdateSiteZipsTask;

public class ProductBuildRegistry {
    private final List<AbstractProductBuild> products = new ArrayList<AbstractProductBuild>();
    private final Map<String, List<AbstractProductBuild>> site2product = new TreeMap<String, List<AbstractProductBuild>>();

    public void add(AbstractProductBuild product, String ... sites) {
        this.add(product, Arrays.asList(sites));
    }

    protected void add(AbstractProductBuild product, Collection<String> sites) {
        if (sites.isEmpty()) {
            throw new IllegalArgumentException("cannot create a product without an update site");
        }
        for (String site : sites) {
            List<AbstractProductBuild> list = this.site2product.get(site);
            if (list == null) {
                list = new ArrayList<AbstractProductBuild>();
                this.site2product.put(site, list);
            }
            list.add(product);
        }
        this.products.add(product);
    }

    public void addAllUpdateSiteTasks(TaskExecutionContext c, BuildDirectories dirs, String siteName, boolean withZip) {
        String[] stringArray;
        if (siteName == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "all";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = siteName;
        }
        String[] sites = stringArray;
        Collection prods = siteName == null ? this.getAllProducts() : (Collection)this.site2product.get(siteName);
        TaskInitJarCache cache = new TaskInitJarCache(dirs.getNewCacheDirectory("jar"));
        c.addTask((Object)cache);
        for (AbstractProductBuild product : prods) {
            product.addUpdateSiteTasks(c, sites);
        }
        if (withZip) {
            c.addTask(UpdateSiteZipsTask.class);
        }
        c.addTask(cache.getCleanup());
    }

    public void addAllProductTasks(TaskExecutionContext c, String siteName) {
        Collection prods = siteName == null ? this.getAllProducts() : (Collection)this.site2product.get(siteName);
        for (AbstractProductBuild product : prods) {
            product.addProductTasks(c, siteName);
        }
    }

    public AbstractProductBuild findProductBuild(String productName) {
        for (AbstractProductBuild product : this.products) {
            if (!product.getOfficialName().equals(productName)) continue;
            return product;
        }
        return null;
    }

    public Collection<AbstractProductBuild> getAllProducts() {
        return this.products;
    }

    public Collection<AbstractProductBuild> getSiteProducts(String siteName) {
        if (siteName == null) {
            return this.getAllProducts();
        }
        return this.site2product.get(siteName);
    }

    public Collection<String> getSites() {
        return this.site2product.keySet();
    }
}

