/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.lcdsl.tasks.p2;

import com.wamas.ide.launching.generator.DependencyResolver;
import com.wamas.ide.launching.lcDsl.LaunchConfig;
import com.wamas.ide.launching.ui.LcDslHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.PluginBuild;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.model.WorkspaceData;

public class TaskGenFeatureFromLcDsl {
    protected final String featureID;
    protected final boolean errorIfNotExist;

    public TaskGenFeatureFromLcDsl(String featureID, boolean errorIfNotExist) {
        this.featureID = featureID;
        this.errorIfNotExist = errorIfNotExist;
    }

    public String toString() {
        return "Generate Feature XML (" + this.featureID + ')';
    }

    @Execute
    public void generateFeatureXml(TaskingLog log, WorkspaceBuild wb, JarManager jm) throws Exception {
        IProject wpobPropertiesProject = WorkspaceData.getProject((String)this.featureID);
        if (wpobPropertiesProject == null) {
            if (!this.errorIfNotExist) {
                return;
            }
            throw new IllegalStateException("cannot find " + this.featureID);
        }
        Set<PluginBuild> allPlugins = TaskGenFeatureFromLcDsl.getPluginsForFeature(log, wpobPropertiesProject, wb, this.errorIfNotExist);
        FeatureBuild targetFeature = wb.getFeature(this.featureID);
        targetFeature.generateFeatureXml(jm, allPlugins, Collections.emptyList());
        wpobPropertiesProject.refreshLocal(2, null);
    }

    public static Set<PluginBuild> getPluginsForFeature(TaskingLog log, IProject featurePrj, WorkspaceBuild wb, boolean errorIfNotExists) throws IOException {
        TreeSet<PluginBuild> allPlugins = new TreeSet<PluginBuild>();
        for (BundleDescription bd : TaskGenFeatureFromLcDsl.getAllDependencies(log, featurePrj)) {
            PluginBuild sourcePlugin = wb.getSourcePlugin(bd.getSymbolicName());
            if (sourcePlugin == null) continue;
            allPlugins.add(sourcePlugin);
        }
        return allPlugins;
    }

    public static List<BundleDescription> getAllDependencies(TaskingLog log, IProject featurePrj) throws FileNotFoundException, IOException {
        File featureDir = featurePrj.getLocation().toFile();
        Properties props = new Properties();
        File propFile = new File(featureDir, "content.properties");
        if (!propFile.exists()) {
            throw new RuntimeException(propFile + " doesn't exist.");
        }
        FileInputStream inStream = new FileInputStream(propFile);
        props.load(inStream);
        inStream.close();
        String dependencies = props.getProperty("dependencies");
        if (dependencies == null) {
            throw new RuntimeException("Please specify at least one ini file for feature \"" + featurePrj.getName() + "\" in your property file.");
        }
        ArrayList<BundleDescription> bds = new ArrayList<BundleDescription>();
        String[] stringArray = dependencies.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lcName = stringArray[n2];
            LaunchConfig lc = LcDslHelper.getInstance().findLaunchConfig(lcName);
            if (lc == null) {
                throw new IllegalStateException("Cannot find launch configuartion " + lcName);
            }
            for (Map.Entry entry : DependencyResolver.findDependencies((LaunchConfig)lc, (boolean)true).entrySet()) {
                bds.add((BundleDescription)entry.getKey());
            }
            ++n2;
        }
        return bds;
    }
}

