/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.live.internal.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationNode;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationTaskNode;

public class VisualizationRootNode
implements VisualizationNode {
    private String name;
    private final List<VisualizationTaskNode> nodes = new ArrayList<VisualizationTaskNode>();
    private final TaskChain chain;
    private final long totalProgress;
    private boolean active = true;
    private TaskExecutionContext tec;

    @Inject
    public VisualizationRootNode(TaskExecutionContext tec, TaskChain chain, @Named(value="org.eclipse.tea.core.prepared_tasks") @Named(value="org.eclipse.tea.core.prepared_tasks") List<?> tasks, @Named(value="org.eclipse.tea.core.prepared_task_contexts") @Named(value="org.eclipse.tea.core.prepared_task_contexts") Map<?, IEclipseContext> taskContexts) {
        this.name = String.valueOf(TaskingModel.getTaskChainName((TaskChain)chain)) + " [" + SimpleDateFormat.getTimeInstance().format(new Date()) + "]";
        this.chain = chain;
        this.tec = tec;
        for (Object t : tasks) {
            this.nodes.add((VisualizationTaskNode)ContextInjectionFactory.make(VisualizationTaskNode.class, (IEclipseContext)taskContexts.get(t)));
        }
        this.totalProgress = this.nodes.stream().collect(Collectors.summarizingInt(VisualizationNode::getTotalProgress)).getSum();
    }

    public List<? extends VisualizationNode> getNodes() {
        return this.nodes;
    }

    public TaskChain getChain() {
        return this.chain;
    }

    public TaskExecutionContext getTaskExecutionContext() {
        return this.tec;
    }

    public VisualizationTaskNode getNodeFor(Object task) {
        return this.nodes.stream().filter(o -> o.getTask() == task).findFirst().orElse(null);
    }

    public void done() {
        for (VisualizationTaskNode n : this.nodes) {
            if (n.isDone()) continue;
            n.skip();
        }
        this.active = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getTotalProgress() {
        return (int)this.totalProgress;
    }

    @Override
    public int getCurrentProgress() {
        if (!this.active) {
            return this.getTotalProgress();
        }
        int total = 0;
        for (VisualizationTaskNode node : this.nodes) {
            total += node.getCurrentProgress();
        }
        return total;
    }

    @Override
    public IStatus getStatus() {
        MultiStatus ms = new MultiStatus("org.eclipse.tea.core.ui.live", 0, this.name, null);
        for (VisualizationTaskNode node : this.nodes) {
            ms.add(node.getStatus());
        }
        return ms;
    }

    @Override
    public long getDuration() {
        return this.nodes.stream().collect(Collectors.summarizingLong(VisualizationNode::getDuration)).getSum();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isDone() {
        return !this.active;
    }

    public void prepareRetry() {
        this.tec = null;
        this.active = false;
        this.name = String.valueOf(this.name) + " (retrying)";
    }
}

