/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.ease.internal;

import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.annotations.TaskChainContextInit;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.ease.EaseScriptTask;
import org.eclipse.tea.ease.internal.EaseTaskWrapper;

public final class EaseTaskChainWrapper
implements TaskChain {
    private final String name;
    private final IScriptEngine scriptEngine;
    private final List<Object> tasks;

    public EaseTaskChainWrapper(String name, IScriptEngine scriptEngine, List<Object> tasks) {
        this.name = name;
        this.scriptEngine = scriptEngine;
        this.tasks = tasks;
    }

    @TaskChainContextInit
    public void init(TaskExecutionContext context) {
        int i = 0;
        while (i < this.tasks.size()) {
            Object task = this.tasks.get(i);
            if (task instanceof TaskChain) {
                ContextInjectionFactory.invoke((Object)task, TaskChainContextInit.class, (IEclipseContext)context.getContext());
            } else if (task instanceof Class && TaskChain.class.isAssignableFrom((Class)task)) {
                Object tc = ContextInjectionFactory.make((Class)((Class)task), (IEclipseContext)context.getContext());
                ContextInjectionFactory.invoke((Object)tc, TaskChainContextInit.class, (IEclipseContext)context.getContext());
            } else if (task instanceof String) {
                context.addTask((Object)new EaseTaskWrapper(this.getShortScriptName((String)task), task, this.scriptEngine));
            } else {
                context.addTask((Object)new EaseTaskWrapper("Anonymous " + i, task, this.scriptEngine));
            }
            ++i;
        }
    }

    private String getShortScriptName(String task) {
        if (task.length() > 20) {
            return String.valueOf(task.substring(0, 17)) + "...";
        }
        return task;
    }

    public void addTask(Object o) {
        this.tasks.add(o);
    }

    public void addScriptTask(String script) {
        this.tasks.add(new EaseScriptTask(script));
    }

    public String toString() {
        return "EASE Dynamic TaskChain: " + this.name;
    }
}

