/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.itcl.internal.core.classes.IncrTclClassesManager;
import org.eclipse.dltk.itcl.internal.core.parser.IncrTclParseUtil;
import org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclClass;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.ITclCommandDetector;
import org.eclipse.dltk.tcl.core.ITclCommandDetectorExtension;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;

public class IncrTclCommandDetector
implements ITclCommandDetector,
ITclCommandDetectorExtension {
    private static final String[] itclCommands = new String[]{"class", "body", "code", "configbody", "delete", "ensemble", "find", "local", "scope"};
    private String prefix = "itcl::";
    private boolean runtimeModel = false;
    private Set names = new HashSet();

    public ITclCommandDetector.CommandInfo detectCommand(TclStatement statement, ModuleDeclaration module, ASTNode decl) {
        if (statement.getCount() == 0) {
            return null;
        }
        Expression commandName = statement.getAt(0);
        if (commandName instanceof SimpleReference) {
            String value = ((SimpleReference)commandName).getName();
            int i = 0;
            while (i < itclCommands.length) {
                if (itclCommands[i].equals(value) || (String.valueOf(this.prefix) + itclCommands[i]).equals(value) || ("::" + this.prefix + itclCommands[i]).equals(value)) {
                    return new ITclCommandDetector.CommandInfo("#itcl#" + itclCommands[i], null);
                }
                ++i;
            }
            return this.checkInstanceOperations(module, decl, statement);
        }
        return null;
    }

    private ITclCommandDetector.CommandInfo checkInstanceOperations(ModuleDeclaration module, ASTNode parent, TclStatement statement) {
        FieldDeclaration variable;
        if (this.runtimeModel) {
            return null;
        }
        Expression commandName = statement.getAt(0);
        if (!(commandName instanceof SimpleReference)) {
            return null;
        }
        String commandNameValue = ((SimpleReference)commandName).getName();
        String[] names = null;
        names = TclParseUtil.tclSplit((String)commandNameValue);
        boolean found = false;
        int i = 0;
        while (i < names.length) {
            if (this.names.contains(names[i])) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            TypeDeclaration type = TclParseUtil.findXOTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)parent, (String)commandNameValue);
            if (statement.getCount() == 1) {
                return null;
            }
            Expression arg = statement.getAt(1);
            if (type != null && arg instanceof SimpleReference) {
                return this.check(type, (SimpleReference)arg);
            }
        }
        if (found && (variable = IncrTclParseUtil.findInstanceVariableDeclarationFrom(module, parent, commandNameValue)) != null) {
            return new ITclCommandDetector.CommandInfo("#itcl#$methodCall", (Object)variable);
        }
        if (IncrTclClassesManager.getDefault().isClass(commandNameValue)) {
            IncrTclGlobalClassParameter param = new IncrTclGlobalClassParameter(commandNameValue);
            return new ITclCommandDetector.CommandInfo("#itcl#$newInstance", (Object)param);
        }
        return null;
    }

    private ITclCommandDetector.CommandInfo check(TypeDeclaration type, SimpleReference arg) {
        if ((type.getModifiers() & 0x200000) == 0) {
            return null;
        }
        String value = arg.getName();
        MethodDeclaration[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if ((methods[i].getModifiers() & 0x400000) != 0 && methods[i].getName().equals(value)) {
                return new ITclCommandDetector.CommandInfo("#itcl#$methodCall", (Object)type);
            }
            ++i;
        }
        return new ITclCommandDetector.CommandInfo("#itcl#$newInstance", (Object)type);
    }

    public void setBuildRuntimeModelFlag(boolean value) {
        this.runtimeModel = value;
    }

    public void processASTNode(ASTNode node) {
        FieldDeclaration decl;
        String name = null;
        if (node instanceof FieldDeclaration) {
            decl = (FieldDeclaration)node;
            name = decl.getName();
        } else if (node instanceof TypeDeclaration) {
            decl = (TypeDeclaration)node;
            name = decl.getName();
        }
        if (name != null) {
            String[] names = null;
            names = TclParseUtil.tclSplit((String)name);
            int i = 0;
            while (i < names.length) {
                this.names.add(names[i]);
                ++i;
            }
        }
    }

    public static class IncrTclGlobalClassParameter {
        private String name;

        public IncrTclGlobalClassParameter(String name) {
            this.name = name;
        }

        public IModelElement resolveElement() {
            IMixinElement[] find = TclMixinModel.getInstance().getMixin(null).find(this.name.replaceAll("::", IMixinRequestor.MIXIN_NAME_SEPARATOR), 1000L);
            if (find.length > 0) {
                int i = 0;
                while (i < find.length) {
                    Object[] allObjects = find[i].getAllObjects();
                    int j = 0;
                    while (j < allObjects.length) {
                        if (allObjects[j] != null && allObjects[j] instanceof IncrTclClass) {
                            IncrTclClass class_ = (IncrTclClass)allObjects[j];
                            return class_.getModelElement();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return null;
        }

        public String getClassName() {
            return this.name;
        }
    }
}

