/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser;

public class RubySpacedParensFixer {
    private static boolean isMethodNameChar(char inputChar, char prevChar) {
        return inputChar >= 'a' && inputChar <= 'z' || inputChar >= '0' && inputChar <= '9' || inputChar >= 'A' && inputChar <= 'Z' || inputChar == '_' || inputChar == '?' && RubySpacedParensFixer.isMethodNameChar(prevChar, '@') || inputChar == '!' && RubySpacedParensFixer.isMethodNameChar(prevChar, '@');
    }

    private static boolean isPrefixKeyword(char[] content, int endOffset) {
        boolean isPrefixKeyword = false;
        int startOffset = -1;
        if (endOffset >= 5 && !(isPrefixKeyword = "return".equals(String.valueOf(content, startOffset = endOffset - 5, 6)))) {
            isPrefixKeyword = "unless".equals(String.valueOf(content, startOffset, 6));
        }
        if (!isPrefixKeyword && endOffset >= 4) {
            startOffset = endOffset - 4;
            isPrefixKeyword = "while".equals(String.valueOf(content, startOffset, 5));
            if (!isPrefixKeyword) {
                isPrefixKeyword = "elsif".equals(String.valueOf(content, startOffset, 5));
            }
            if (!isPrefixKeyword) {
                isPrefixKeyword = "until".equals(String.valueOf(content, startOffset, 5));
            }
        }
        if (!isPrefixKeyword && endOffset >= 3 && !(isPrefixKeyword = "then".equals(String.valueOf(content, startOffset = endOffset - 3, 4)))) {
            isPrefixKeyword = "case".equals(String.valueOf(content, startOffset, 4));
        }
        if (!isPrefixKeyword && endOffset >= 2) {
            startOffset = endOffset - 2;
            isPrefixKeyword = "and".equals(String.valueOf(content, startOffset, 3));
        }
        if (!isPrefixKeyword && endOffset >= 1 && !(isPrefixKeyword = "if".equals(String.valueOf(content, startOffset = endOffset - 1, 2)))) {
            isPrefixKeyword = "or".equals(String.valueOf(content, startOffset, 2));
        }
        if (isPrefixKeyword) {
            isPrefixKeyword = startOffset == 0 || !RubySpacedParensFixer.isMethodNameChar(content[startOffset - 1], startOffset > 1 ? content[startOffset - 2] : (char)'@');
        }
        return isPrefixKeyword;
    }

    public static char[] fixSpacedParens(char[] content) {
        char[] fixedContent = new char[content.length];
        System.arraycopy(content, 0, fixedContent, 0, content.length);
        boolean inComment = false;
        boolean inSingleString = false;
        boolean inDoubleString = false;
        boolean inBackQuoteString = false;
        boolean inBraceString = false;
        boolean inInterpString = false;
        boolean inRegexp = false;
        int cnt = 0;
        int max = fixedContent.length;
        while (cnt < max) {
            if (!(cnt <= 1 || inComment || inSingleString || inDoubleString || inBackQuoteString || inBraceString || inRegexp || fixedContent[cnt] != '(' || fixedContent[cnt - 1] != ' ')) {
                if (RubySpacedParensFixer.isMethodNameChar(fixedContent[cnt - 2], cnt > 2 ? fixedContent[cnt - 3] : (char)'@') && !RubySpacedParensFixer.isPrefixKeyword(fixedContent, cnt - 2)) {
                    fixedContent[cnt - 1] = 40;
                    fixedContent[cnt] = 32;
                }
            } else if (fixedContent[cnt] == '#') {
                if ((inSingleString || inDoubleString || inBackQuoteString || inBraceString || inRegexp) && fixedContent[cnt + 1] == '{') {
                    inInterpString = true;
                } else if (!(inSingleString || inDoubleString || inBackQuoteString || inBraceString)) {
                    inComment = true;
                }
            } else if (fixedContent[cnt] == '\r' || fixedContent[cnt] == '\n') {
                inComment = false;
            } else if (fixedContent[cnt] == '\"') {
                if ((cnt < 1 || fixedContent[cnt - 1] != '\\') && !inComment & !inInterpString) {
                    inDoubleString = !inDoubleString;
                }
            } else if (fixedContent[cnt] == '\'') {
                if (!(cnt >= 1 && fixedContent[cnt - 1] == '\\' || inComment)) {
                    inSingleString = !inSingleString;
                }
            } else if (fixedContent[cnt] == '`') {
                if (!(cnt >= 1 && fixedContent[cnt - 1] == '\\' || inComment)) {
                    inBackQuoteString = !inBackQuoteString;
                }
            } else if (fixedContent[cnt] == '{') {
                if (!(cnt >= 1 && fixedContent[cnt - 1] != '%' || inComment)) {
                    inBraceString = true;
                }
            } else if (fixedContent[cnt] == '}') {
                if (!(cnt >= 1 && fixedContent[cnt - 1] == '\\' || inComment)) {
                    if (inInterpString) {
                        inInterpString = false;
                    } else {
                        inBraceString = false;
                    }
                }
            } else if (!(fixedContent[cnt] != '/' || cnt >= 1 && fixedContent[cnt - 1] == '\\' || inComment || inSingleString || inDoubleString || inBackQuoteString || inBraceString)) {
                inRegexp = !inRegexp;
            }
            ++cnt;
        }
        return fixedContent;
    }
}

