/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.formatter.AbstractScriptFormatter;
import org.eclipse.dltk.formatter.FormatterDocument;
import org.eclipse.dltk.formatter.FormatterIndentDetector;
import org.eclipse.dltk.formatter.FormatterWriter;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.ruby.formatter.internal.DumpContentException;
import org.eclipse.dltk.ruby.formatter.internal.Messages;
import org.eclipse.dltk.ruby.formatter.internal.RubyFormatterContext;
import org.eclipse.dltk.ruby.formatter.internal.RubyFormatterNodeBuilder;
import org.eclipse.dltk.ruby.formatter.internal.RubyFormatterNodeRewriter;
import org.eclipse.dltk.ruby.formatter.internal.RubyFormatterPlugin;
import org.eclipse.dltk.ruby.formatter.internal.RubyParser;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.formatter.FormatterSyntaxProblemException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jruby.parser.RubyParserResult;

public class RubyFormatter
extends AbstractScriptFormatter {
    protected static final String[] INDENTING = new String[]{"indent.class", "indent.module", "indent.method", "indent.blocks", "indent.if", "indent.case", "indent.when"};
    protected static final String[] BLANK_LINES = new String[]{"line.file.require.after", "line.file.module.between", "line.file.class.between", "line.file.method.between", "line.first.before", "line.module.before", "line.class.before", "line.method.before"};
    private final String lineDelimiter;

    public RubyFormatter(String lineDelimiter, Map preferences) {
        super(preferences);
        this.lineDelimiter = lineDelimiter;
    }

    public int detectIndentationLevel(IDocument document, int offset) {
        String input = document.get();
        try {
            RubyParserResult result = RubyParser.parse(input);
            RubyFormatterNodeBuilder builder = new RubyFormatterNodeBuilder();
            FormatterDocument fDocument = this.createDocument(input);
            IFormatterContainerNode root = builder.build(result, (IFormatterDocument)fDocument);
            new RubyFormatterNodeRewriter(result).rewrite(root);
            RubyFormatterContext context = new RubyFormatterContext(0);
            FormatterIndentDetector detector = new FormatterIndentDetector(offset);
            try {
                root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                return detector.getLevel();
            }
            catch (Exception exception) {
            }
        }
        catch (FormatterSyntaxProblemException formatterSyntaxProblemException) {}
        return 0;
    }

    public TextEdit format(String source, int offset, int length, int indent) throws FormatterException {
        RubyParserResult result;
        String input = source.substring(offset, offset + length);
        String output = this.format(input, result = RubyParser.parse(input), indent);
        if (output != null) {
            if (!input.equals(output)) {
                if (!this.isValidation() || this.equalsIgnoreBlanks(new StringReader(input), new StringReader(output))) {
                    return new ReplaceEdit(offset, length, output);
                }
                RubyFormatterPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.ruby.formatter", 0, Messages.RubyFormatter_contentCorrupted, (Throwable)new DumpContentException(input)));
            } else {
                return new MultiTextEdit();
            }
        }
        return null;
    }

    protected boolean isValidation() {
        return !this.getBoolean("wrap.comments");
    }

    private String format(String input, RubyParserResult result, int indent) {
        RubyFormatterNodeBuilder builder = new RubyFormatterNodeBuilder();
        FormatterDocument document = this.createDocument(input);
        IFormatterContainerNode root = builder.build(result, (IFormatterDocument)document);
        new RubyFormatterNodeRewriter(result).rewrite(root);
        RubyFormatterContext context = new RubyFormatterContext(indent);
        FormatterWriter writer = new FormatterWriter((IFormatterDocument)document, this.lineDelimiter, this.createIndentGenerator());
        writer.setWrapLength(this.getInt("wrap.comments.length"));
        writer.setLinesPreserve(this.getInt("lines.preserve"));
        try {
            root.accept((IFormatterContext)context, (IFormatterWriter)writer);
            writer.flush((IFormatterContext)context);
            return writer.getOutput();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private FormatterDocument createDocument(String input) {
        FormatterDocument document = new FormatterDocument(input);
        int i = 0;
        while (i < INDENTING.length) {
            document.setBoolean(INDENTING[i], this.getBoolean(INDENTING[i]));
            ++i;
        }
        i = 0;
        while (i < BLANK_LINES.length) {
            document.setInt(BLANK_LINES[i], this.getInt(BLANK_LINES[i]));
            ++i;
        }
        document.setInt("formatter.tabulation.size", this.getInt("formatter.tabulation.size"));
        document.setBoolean("wrap.comments", this.getBoolean("wrap.comments"));
        return document;
    }

    public static boolean isBooleanOption(String optionName) {
        int i = 0;
        while (i < INDENTING.length) {
            if (INDENTING[i].equals(optionName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIntegerOption(String optionName) {
        int i = 0;
        while (i < BLANK_LINES.length) {
            if (BLANK_LINES[i].equals(optionName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean equalsIgnoreBlanks(Reader inputReader, Reader outputReader) {
        String outputLine;
        String inputLine;
        LineNumberReader input = new LineNumberReader(inputReader);
        LineNumberReader output = new LineNumberReader(outputReader);
        do {
            inputLine = this.readLine(input);
            outputLine = this.readLine(output);
            if (inputLine == null) {
                return outputLine == null;
            }
            if (outputLine != null) continue;
            return false;
        } while (inputLine.equals(outputLine));
        return false;
    }

    private String readLine(LineNumberReader reader) {
        String line;
        do {
            try {
                line = reader.readLine();
            }
            catch (IOException iOException) {
                return null;
            }
            if (line != null) continue;
            return line;
        } while ((line = line.trim()).length() == 0);
        return line;
    }
}

