/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;

public class DLTKTestingPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_TEST = "isTest";
    private static final String PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST = "canLaunchAsJUnit";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IModelElement element;
        if (!(receiver instanceof IAdaptable)) {
            throw new IllegalArgumentException("Element must be of type 'IAdaptable', is " + receiver == null ? "null" : receiver.getClass().getName());
        }
        if (receiver instanceof IModelElement) {
            element = (IModelElement)receiver;
        } else if (receiver instanceof IResource) {
            element = DLTKCore.create((IResource)((IResource)receiver));
            if (element == null) {
                return false;
            }
        } else {
            IAdaptable iAdaptable = (IAdaptable)receiver;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (IModelElement)iAdaptable.getAdapter((Class)clazz)) == null) {
                IResource resource;
                IAdaptable iAdaptable2 = (IAdaptable)receiver;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = DLTKCore.create((IResource)(resource = (IResource)iAdaptable2.getAdapter((Class)clazz2)))) == null) {
                    return false;
                }
                return false;
            }
        }
        if (PROPERTY_IS_TEST.equals(property)) {
            return this.isTest(element);
        }
        if (PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST.equals(property)) {
            return this.canLaunchAsTest(element);
        }
        throw new IllegalArgumentException("Unknown test property '" + property + "'");
    }

    private boolean canLaunchAsTest(IModelElement element) {
        switch (element.getElementType()) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 5: 
            case 7: 
            case 9: {
                return this.isTest(element);
            }
        }
        return false;
    }

    private boolean isTest(IModelElement element) {
        try {
            IType testType = null;
            if (element instanceof ISourceModule) {
                IType[] allTypes = ((ISourceModule)element).getAllTypes();
                if (allTypes.length > 0) {
                    testType = allTypes[0];
                }
            } else if (element instanceof IType) {
                testType = (IType)element;
            } else if (element instanceof IMember) {
                testType = ((IMember)element).getDeclaringType();
            }
            if (testType != null && testType.exists()) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

