/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.core;

import java.util.Arrays;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.parser.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parser.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parser.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parser.raw.TclScript;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclDocumentationNode;

public class XOTclDocumentationProcessor
extends AbstractTclCommandProcessor
implements ITclCommandProcessor {
    public void preprocessStatement(TclStatement st) {
        ASTNode[] nodes = st.getExpressions().toArray(new ASTNode[st.getCount()]);
        int i = 0;
        while (i < nodes.length) {
            block6: {
                if (nodes[i] instanceof TclBlockExpression) {
                    TclBlockExpression tclExecuteExpression = (TclBlockExpression)nodes[i];
                    String expression = tclExecuteExpression.getBlock();
                    expression = expression.substring(1, expression.length() - 1);
                    Block newExpr = new Block();
                    nodes[i] = newExpr;
                    st.setExpressions(Arrays.asList(nodes));
                    try {
                        TclScript parse = SimpleTclParser.staticParse((String)expression);
                        List commands = parse.getCommands();
                        int j = 0;
                        while (j < commands.size()) {
                            if (commands.get(j) instanceof TclCommand) {
                                TclStatement st2 = TclParseUtil.convertToAST((TclCommand)((TclCommand)commands.get(j)), (char[])"".toCharArray(), (int)0, (String)expression, (int)0);
                                newExpr.addStatement((ASTNode)st2);
                            }
                            ++j;
                        }
                    }
                    catch (TclParseException e) {
                        if (!DLTKCore.DEBUG) break block6;
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        st.setExpressions(Arrays.asList(nodes));
    }

    public ASTNode process(TclStatement st, ITclParser parser, ASTNode parent) {
        XOTclDocumentationNode doc = new XOTclDocumentationNode();
        String objName = TclParseUtil.getNameFromNode((ASTNode)st.getAt(1));
        if (objName != null) {
            doc.setStart(st.sourceStart());
            doc.setEnd(st.sourceEnd());
            if ("Class".equals(objName)) {
                String name = TclParseUtil.getNameFromNode((ASTNode)st.getAt(2));
                if (name != null) {
                    this.processAddDescriptions(name, st, doc);
                }
            } else if ("Object".equals(objName)) {
                String name = TclParseUtil.getNameFromNode((ASTNode)st.getAt(2));
                if (name != null) {
                    this.processAddDescriptions(name, st, doc);
                }
            } else {
                String name;
                String docCommand = TclParseUtil.getNameFromNode((ASTNode)st.getAt(2));
                if (docCommand != null && "instproc".equals(docCommand) && (name = TclParseUtil.getNameFromNode((ASTNode)st.getAt(3))) != null) {
                    this.processAddDescriptions(String.valueOf(objName) + "::" + name, st, doc);
                }
            }
        }
        this.addToParent(parent, (ASTNode)doc);
        return doc;
    }

    private void processAddDescriptions(final String name, TclStatement st, final XOTclDocumentationNode doc) {
        this.preprocessStatement(st);
        try {
            st.traverse(new ASTVisitor(){

                public boolean visit(Statement s) throws Exception {
                    TclStatement s2;
                    String n;
                    if (s instanceof TclStatement && (n = TclParseUtil.getNameFromNode((ASTNode)(s2 = (TclStatement)s).getAt(0))) != null && n.equals("description") && s2.getCount() > 1 && s2.getAt(1) instanceof TclBlockExpression) {
                        TclBlockExpression bl = (TclBlockExpression)s2.getAt(1);
                        String blvalue = bl.getBlock();
                        doc.appendDescription(name, blvalue.substring(1, blvalue.length() - 1));
                    }
                    return super.visit(s);
                }
            });
        }
        catch (Exception exception) {}
    }
}

