/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.debug.core.IDLTKDebugToolkit;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.dltk.debug.ui.breakpoints.ScriptBreakpointPropertyPage;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ScriptWatchpointPropertyPage
extends ScriptBreakpointPropertyPage {
    private Button suspendOnAccessButton;
    private Button suspendOnModificationButton;

    protected void createTypeSpecificLabels(Composite parent) throws CoreException {
        this.setTitle(BreakpointMessages.WatchpointTitle);
        IScriptWatchpoint watchPoint = (IScriptWatchpoint)this.getBreakpoint();
        SWTFactory.createLabel((Composite)parent, (String)BreakpointMessages.WatchFieldLabel, (int)1);
        SWTFactory.createLabel((Composite)parent, (String)watchPoint.getFieldName(), (int)1);
    }

    protected boolean hasExpressionEditor() {
        return false;
    }

    protected void createTypeSpecificButtons(Composite parent) {
        this.suspendOnAccessButton = SWTFactory.createCheckButton((Composite)parent, (String)BreakpointMessages.SuspendOnAccessLabel, null, (boolean)false, (int)1);
        this.suspendOnModificationButton = SWTFactory.createCheckButton((Composite)parent, (String)BreakpointMessages.SuspendOnModificationLabel, null, (boolean)false, (int)1);
    }

    protected void loadValues() throws CoreException {
        super.loadValues();
        IScriptWatchpoint watchpoint = (IScriptWatchpoint)this.getBreakpoint();
        IDLTKDebugToolkit debugToolkit = ScriptDebugManager.getInstance().getDebugToolkitByDebugModel(watchpoint.getModelIdentifier());
        if (debugToolkit.isAccessWatchpointSupported()) {
            this.suspendOnAccessButton.setSelection(watchpoint.isAccess());
            this.suspendOnModificationButton.setSelection(watchpoint.isModification());
        } else {
            this.suspendOnAccessButton.setEnabled(false);
            this.suspendOnModificationButton.setEnabled(false);
            this.suspendOnModificationButton.setSelection(true);
        }
    }

    protected void saveValues() throws CoreException {
        super.saveValues();
        IScriptWatchpoint watchpoint = (IScriptWatchpoint)this.getBreakpoint();
        IDLTKDebugToolkit debugToolkit = ScriptDebugManager.getInstance().getDebugToolkitByDebugModel(watchpoint.getModelIdentifier());
        if (debugToolkit.isAccessWatchpointSupported()) {
            watchpoint.setAccess(this.suspendOnAccessButton.getSelection());
            watchpoint.setModification(this.suspendOnModificationButton.getSelection());
        }
    }
}

