/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.launching.EnvironmentVariable;

public final class EnvironmentResolver {
    public static EnvironmentVariable[] resolve(Map penv, EnvironmentVariable[] variables) {
        return EnvironmentResolver.resolve(penv, variables, false);
    }

    public static EnvironmentVariable[] resolve(Map penv, EnvironmentVariable[] variables, boolean keepUnresolved) {
        if (variables == null) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        HashMap selfDep = new HashMap();
        for (String name : penv.keySet()) {
            String value = (String)penv.get(name);
            env.put(name, value);
        }
        int i = 0;
        while (i < variables.length) {
            String name;
            name = variables[i].getName();
            if (env.containsKey(name)) {
                selfDep.put(name, env.get(name));
                env.remove(name);
            }
            ++i;
        }
        HashMap<String, String> resolved = new HashMap<String, String>();
        ArrayList<EnvironmentVariable> result = new ArrayList<EnvironmentVariable>();
        ArrayList<REnvironmentVariable> unresolved = new ArrayList<REnvironmentVariable>();
        int i2 = 0;
        while (i2 < variables.length) {
            REnvironmentVariable var = new REnvironmentVariable(new EnvironmentVariable(variables[i2]));
            EnvironmentResolver.fillDependencies(var, variables);
            unresolved.add(var);
            ++i2;
        }
        int maxCycles = 1000;
        while (unresolved.size() > 0) {
            if (--maxCycles < 0) break;
            Iterator iterator = unresolved.iterator();
            while (iterator.hasNext()) {
                REnvironmentVariable var = (REnvironmentVariable)iterator.next();
                if (EnvironmentResolver.isResolved(var.var)) {
                    result.add(var.var);
                    resolved.put(var.var.getName(), var.var.getValue());
                    iterator.remove();
                    continue;
                }
                if (EnvironmentResolver.isCyclic(var, unresolved)) {
                    if (EnvironmentResolver.isSelfCyclic(var)) {
                        EnvironmentResolver.resolveVariable(var, env);
                        EnvironmentResolver.resolveVariable(var, selfDep);
                        if (EnvironmentResolver.isResolved(var.var)) continue;
                    }
                    if (keepUnresolved) {
                        result.add(var.var);
                    }
                    iterator.remove();
                    continue;
                }
                EnvironmentResolver.resolveVariable(var, resolved);
                EnvironmentResolver.resolveVariable(var, env);
                if (EnvironmentResolver.isResolved(var.var) || !EnvironmentResolver.isUnresolvable(var, unresolved)) continue;
                if (keepUnresolved) {
                    result.add(var.var);
                }
                iterator.remove();
            }
        }
        return result.toArray(new EnvironmentVariable[result.size()]);
    }

    private static boolean isSelfCyclic(REnvironmentVariable var) {
        if (var.dependencies.isEmpty()) {
            return false;
        }
        return var.dependencies.contains(var.var.getName());
    }

    private static void fillDependencies(REnvironmentVariable var, EnvironmentVariable[] variables) {
        int j = 0;
        while (j < variables.length) {
            if (EnvironmentResolver.containVar(var.var, variables[j].getName())) {
                var.dependencies.add(variables[j].getName());
            }
            ++j;
        }
    }

    private static boolean isUnresolvable(REnvironmentVariable var, List unresolved) {
        boolean step;
        EnvironmentVariable t = var.var;
        do {
            step = false;
            for (REnvironmentVariable rvar : unresolved) {
                if (rvar.var.getName().equals(t.getName()) || !EnvironmentResolver.containVar(t, rvar.var.getName())) continue;
                t = EnvironmentResolver.resolveVariable(t, rvar.var.getName(), rvar.var.getValue());
                step = true;
            }
        } while (step);
        return !EnvironmentResolver.isResolved(t);
    }

    private static EnvironmentVariable resolveVariable(EnvironmentVariable var, String name, String value) {
        String result = var.getValue();
        String pattern = "$" + name;
        if (value.indexOf(pattern) != -1) {
            return null;
        }
        int pos = result.indexOf(pattern);
        while (pos != -1) {
            result = String.valueOf(result.substring(0, pos)) + value + result.substring(pos + pattern.length());
            pos = result.indexOf(pattern, pos);
        }
        return new EnvironmentVariable(var.getName(), result);
    }

    private static boolean isCyclic(REnvironmentVariable var, List unresolved) {
        if (var.dependencies.size() == 0) {
            return false;
        }
        for (REnvironmentVariable env2 : unresolved) {
            if (!var.dependencies.contains(env2.var.getName()) || !env2.dependencies.contains(var.var.getName())) continue;
            return true;
        }
        return false;
    }

    private static void resolveVariable(REnvironmentVariable var, Map env) {
        EnvironmentVariable v = var.var;
        for (String varName : env.keySet()) {
            if (!EnvironmentResolver.containVar(v, varName)) continue;
            v = EnvironmentResolver.resolveVariable(v, varName, (String)env.get(varName));
        }
        var.var = v;
    }

    public static boolean isResolved(EnvironmentVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        String name = var.getValue();
        return name.indexOf("$") == -1;
    }

    public static boolean containVar(EnvironmentVariable var, String vName) {
        String ref;
        if (var == null) {
            throw new IllegalArgumentException();
        }
        String value = var.getValue();
        int pos = value.indexOf(ref = "$" + vName);
        return pos != -1 && (pos + ref.length() >= value.length() || !Character.isLetterOrDigit(value.charAt(pos + ref.length())));
    }

    private static class REnvironmentVariable {
        EnvironmentVariable var;
        final Set dependencies = new HashSet();

        public REnvironmentVariable(EnvironmentVariable var) {
            this.var = var;
        }
    }
}

