/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.matching;

import java.text.Annotation;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.lookup.Scope;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.search.matching.FieldLocator;
import org.eclipse.dltk.internal.core.search.matching.FieldPattern;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationLocator;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodLocator;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;
import org.eclipse.dltk.internal.core.search.matching.OrLocator;
import org.eclipse.dltk.internal.core.search.matching.OrPattern;
import org.eclipse.dltk.internal.core.search.matching.TypeDeclarationLocator;
import org.eclipse.dltk.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.TypeReferenceLocator;
import org.eclipse.dltk.internal.core.search.matching.TypeReferencePattern;

public abstract class PatternLocator
implements IIndexConstants {
    protected int matchMode;
    protected boolean isCaseSensitive;
    protected boolean isCamelCase;
    protected boolean isEquivalentMatch;
    protected boolean isErasureMatch;
    protected Pattern compiledPattern;
    SearchMatch match = null;
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int INACCURATE_MATCH = 1;
    public static final int POSSIBLE_MATCH = 2;
    public static final int ACCURATE_MATCH = 3;
    public static final int ERASURE_MATCH = 4;
    protected static final int POSSIBLE_FULL_MATCH = 0x400002;
    protected static final int POSSIBLE_PREFIX_MATCH = 65538;
    protected static final int POSSIBLE_PATTERN_MATCH = 131074;
    protected static final int POSSIBLE_REGEXP_MATCH = 262146;
    protected static final int POSSIBLE_CAMELCASE_MATCH = 0x800002;
    public static final int NODE_SET_MASK = 255;
    protected static final int POSSIBLE_MATCH_MASK = -256;
    public static final int COMPILATION_UNIT_CONTAINER = 1;
    public static final int CLASS_CONTAINER = 2;
    public static final int METHOD_CONTAINER = 4;
    public static final int FIELD_CONTAINER = 8;
    public static final int ALL_CONTAINER = 15;
    public static final int RAW_MASK = 48;
    public static final int RULE_MASK = 48;

    public static PatternLocator patternLocator(SearchPattern pattern, IDLTKLanguageToolkit toolkit) {
        switch (pattern.kind) {
            case 4: {
                return new TypeReferenceLocator((TypeReferencePattern)pattern);
            }
            case 8: {
                return new TypeDeclarationLocator((TypeDeclarationPattern)pattern);
            }
            case 2048: {
                return new MethodDeclarationLocator((MethodDeclarationPattern)pattern);
            }
            case 64: {
                return new FieldLocator((FieldPattern)pattern);
            }
            case 128: {
                return new MethodLocator((MethodPattern)pattern);
            }
            case 256: {
                return new OrLocator((OrPattern)pattern);
            }
        }
        return null;
    }

    public static char[] qualifiedPattern(char[] simpleNamePattern, char[] qualificationPattern) {
        if (simpleNamePattern == null) {
            if (qualificationPattern == null) {
                return null;
            }
            return CharOperation.concat(qualificationPattern, ONE_STAR, '.');
        }
        return qualificationPattern == null ? CharOperation.concat(ONE_STAR, simpleNamePattern) : CharOperation.concat(qualificationPattern, simpleNamePattern, '.');
    }

    public PatternLocator(SearchPattern pattern) {
        int matchRule = pattern.getMatchRule();
        this.isCaseSensitive = (matchRule & 8) != 0;
        this.isCamelCase = (matchRule & 0x80) != 0;
        this.isErasureMatch = (matchRule & 0x10) != 0;
        this.isEquivalentMatch = (matchRule & 0x20) != 0;
        this.matchMode = matchRule & 7;
    }

    protected void clear() {
    }

    protected char[] getQualifiedPattern(char[] simpleNamePattern, char[] qualificationPattern) {
        if (simpleNamePattern == null) {
            if (qualificationPattern == null) {
                return null;
            }
            return CharOperation.concat(qualificationPattern, ONE_STAR, '.');
        }
        if (qualificationPattern == null) {
            return simpleNamePattern;
        }
        return CharOperation.concat(qualificationPattern, simpleNamePattern, '.');
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
    }

    public int match(Annotation node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(CallExpression node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(Expression node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(Reference node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(FieldDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(TypeDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int matchContainer() {
        return 15;
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return this.matchNameValue(pattern, name) != 0;
    }

    protected int matchNameValue(char[] pattern, char[] name) {
        boolean canBePrefix;
        if (pattern == null) {
            return 3;
        }
        if (name == null) {
            return 0;
        }
        if (name.length == 0) {
            if (pattern.length == 0) {
                return 3;
            }
            return 0;
        }
        if (pattern.length == 0) {
            return 0;
        }
        boolean matchFirstChar = !this.isCaseSensitive || pattern[0] == name[0];
        boolean sameLength = pattern.length == name.length;
        boolean bl = canBePrefix = name.length >= pattern.length;
        if (this.isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(pattern, name)) {
            return 0x800002;
        }
        switch (this.matchMode) {
            case 0: {
                if (!this.isCamelCase) {
                    if (!sameLength || !matchFirstChar || !CharOperation.equals(pattern, name, this.isCaseSensitive)) break;
                    return 0x400002;
                }
            }
            case 1: {
                if (!canBePrefix || !matchFirstChar || !CharOperation.prefixEquals(pattern, name, this.isCaseSensitive)) break;
                return 65538;
            }
            case 2: {
                if (!this.isCaseSensitive) {
                    pattern = CharOperation.toLowerCase(pattern);
                }
                if (!CharOperation.match(pattern, name, this.isCaseSensitive)) break;
                return 2;
            }
            case 4: {
                if (this.compiledPattern == null) {
                    this.compiledPattern = Pattern.compile(new String(pattern), this.isCaseSensitive ? 0 : 2);
                }
                if (!this.compiledPattern.matcher(new String(name)).matches()) break;
                return 262146;
            }
        }
        return 0;
    }

    protected void matchReportReference(ASTNode reference, IModelElement element, int accuracy, MatchLocator locator) throws CoreException {
        this.match = null;
        switch (this.referenceType()) {
            case 7: {
                this.match = locator.newTypeReferenceMatch(element, accuracy, reference.matchStart(), reference.matchLength(), reference);
                break;
            }
            case 8: {
                this.match = locator.newFieldReferenceMatch(element, accuracy, reference.matchStart(), reference.matchLength(), reference);
                break;
            }
            case 9: {
                this.match = locator.newMethodReferenceMatch(element, accuracy, reference.matchStart(), reference.matchLength(), false, false, reference);
            }
        }
        if (this.match != null) {
            locator.report(this.match);
        }
    }

    protected void matchReportReference(ASTNode reference, IModelElement element, IModelElement localElement, IModelElement[] otherElements, int accuracy, MatchLocator locator) throws CoreException {
        this.matchReportReference(reference, element, accuracy, locator);
    }

    public void matchReportReference(ASTNode reference, IModelElement element, Scope scope, int accuracy, MatchLocator locator) throws CoreException {
        this.matchReportReference(reference, element, accuracy, locator);
    }

    public final SearchMatch newDeclarationMatch(ASTNode reference, IModelElement element, int accuracy, int length, MatchLocator locator) {
        return this.newDeclarationMatch(reference, element, accuracy, locator);
    }

    public SearchMatch newDeclarationMatch(ASTNode reference, IModelElement element, int accuracy, MatchLocator locator) {
        return locator.newDeclarationMatch(element, accuracy, reference.matchStart(), reference.matchLength());
    }

    protected int referenceType() {
        return 0;
    }

    public int resolveLevel(ASTNode possibleMatchingNode) {
        return 0;
    }

    protected void updateMatch(MatchLocator locator, char[][] patternArguments, boolean hasTypeParameters) {
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: updateMatch");
        }
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern) {
        return 1;
    }

    protected int resolveLevelForType(char[] qualifiedPattern) {
        return 0;
    }

    public String toString() {
        return "SearchPattern";
    }
}

