/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.UserLibrary;
import org.eclipse.dltk.internal.core.util.Util;

public class UserLibraryBuildpathContainer
implements IBuildpathContainer {
    private String name;
    private IDLTKLanguageToolkit toolkit;

    public UserLibraryBuildpathContainer(String name, IDLTKLanguageToolkit languageToolkit) {
        this.name = name;
        this.toolkit = languageToolkit;
    }

    public IBuildpathEntry[] getBuildpathEntries(IScriptProject project) {
        UserLibrary library = this.getUserLibrary();
        if (library != null) {
            return library.getEntries();
        }
        return new IBuildpathEntry[0];
    }

    public String getDescription(IScriptProject project) {
        return this.name;
    }

    public int getKind() {
        UserLibrary library = this.getUserLibrary();
        if (library != null && library.isSystemLibrary()) {
            return 2;
        }
        return 1;
    }

    public IPath getPath() {
        return new Path("org.eclipse.dltk.USER_LIBRARY").append(this.name);
    }

    private UserLibrary getUserLibrary() {
        UserLibrary userLibrary = ModelManager.getUserLibraryManager().getUserLibrary(this.name, this.toolkit);
        if (userLibrary == null && ModelManager.BP_RESOLVE_VERBOSE) {
            this.verbose_no_user_library_found(this.name);
        }
        return userLibrary;
    }

    private void verbose_no_user_library_found(String userLibraryName) {
        Util.verbose("UserLibrary INIT - FAILED (no user library found)\n\tuserLibraryName: " + userLibraryName);
    }

    public IBuiltinModuleProvider getBuiltinProvider(IScriptProject project) {
        return null;
    }
}

