/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ti.statistics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.statistics.GoalEvaluationStatistics;
import org.eclipse.dltk.ti.statistics.GoalEvaluationStep;
import org.eclipse.dltk.ti.statistics.IEvaluationStatisticsRequestor;

public class GoalEvalutationRecorder
implements IEvaluationStatisticsRequestor {
    private IGoal rootRoal;
    private Map goalStats = new HashMap();

    public GoalEvalutationRecorder duplicate() {
        GoalEvalutationRecorder n = new GoalEvalutationRecorder();
        n.rootRoal = this.rootRoal;
        for (Object k : this.goalStats.keySet()) {
            n.goalStats.put(k, this.goalStats.get(k));
        }
        return n;
    }

    public void evaluationStarted(IGoal rootGoal) {
        this.reset();
        this.rootRoal = rootGoal;
        this.goalStats.put(rootGoal, new GoalEvaluationStatistics(rootGoal));
    }

    private void reset() {
        this.rootRoal = null;
        this.goalStats = new HashMap();
    }

    private GoalEvaluationStatistics addGoalStatistics(GoalEvaluationStatistics parent, IGoal g) {
        GoalEvaluationStatistics s = new GoalEvaluationStatistics(g);
        s.setParentStat(parent);
        this.goalStats.put(g, s);
        return s;
    }

    private GoalEvaluationStatistics[] createEmptyGoalStatistics(GoalEvaluationStatistics parent, IGoal[] subgoals) {
        GoalEvaluationStatistics[] r = new GoalEvaluationStatistics[subgoals.length];
        int i = 0;
        while (i < subgoals.length) {
            r[i] = this.addGoalStatistics(parent, subgoals[i]);
            ++i;
        }
        return r;
    }

    public void evaluatorInitialized(GoalEvaluator evaluator, IGoal[] subgoals, long time) {
        this.appendStep(evaluator, subgoals, null, time, 0);
    }

    public void evaluatorProducedResult(GoalEvaluator evaluator, Object result, long time) {
        GoalEvaluationStatistics s = this.appendStep(evaluator, null, result, time, 2);
        if (s != null) {
            s.setTimeEnd(System.currentTimeMillis());
        }
    }

    public void evaluatorReceivedResult(GoalEvaluator evaluator, IGoal finishedGoal, IGoal[] subgoals, long time) {
        this.appendStep(evaluator, subgoals, null, time, 1);
    }

    private GoalEvaluationStatistics appendStep(GoalEvaluator evaluator, IGoal[] subgoals, Object result, long time, int kind) {
        IGoal goal = evaluator.getGoal();
        GoalEvaluationStatistics stat = (GoalEvaluationStatistics)this.goalStats.get(goal);
        if (stat != null) {
            GoalEvaluationStep step = new GoalEvaluationStep(kind);
            step.setTime(time);
            if (subgoals != null) {
                step.setSubgoalsStats(this.createEmptyGoalStatistics(stat, subgoals));
            }
            step.setResult(result);
            stat.getSteps().add(step);
            return stat;
        }
        System.err.println("Unknown goal: " + goal);
        return null;
    }

    public void goalEvaluatorAssigned(IGoal goal, GoalEvaluator evaluator) {
        GoalEvaluationStatistics stat = (GoalEvaluationStatistics)this.goalStats.get(goal);
        if (stat != null) {
            stat.setEvaluator(evaluator);
        } else {
            System.err.println("Unknown goal: " + goal);
        }
    }

    public void goalStateChanged(IGoal goal, GoalState state, GoalState oldState) {
        GoalEvaluationStatistics stat = (GoalEvaluationStatistics)this.goalStats.get(goal);
        if (stat != null) {
            stat.setState(state);
        } else {
            System.err.println("Unknown goal: " + goal);
        }
    }

    public IGoal getRootRoal() {
        return this.rootRoal;
    }

    public GoalEvaluationStatistics getStatisticsForGoal(IGoal g) {
        return (GoalEvaluationStatistics)this.goalStats.get(g);
    }
}

