/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.testing.internal.tcltest;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.testing.ITclTestingEngine;
import org.eclipse.dltk.tcl.testing.internal.tcltest.Activator;
import org.eclipse.dltk.tcl.testing.internal.tcltest.TcltestOutputProcessor;
import org.eclipse.dltk.testing.ITestingProcessor;

public class TclTestTestingEngine
implements ITclTestingEngine {
    public String getId() {
        return "org.eclipse.dltk.tcl.testing.tcltest.testingEngine";
    }

    public String getName() {
        return "Tcl Test";
    }

    public ITestingProcessor getProcessor(ILaunch launch) {
        return new TcltestOutputProcessor(launch);
    }

    public boolean isValidModule(ISourceModule module) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
        ASTNode[] findTests = this.findTests(moduleDeclaration);
        return findTests.length > 0;
    }

    private ASTNode[] findTests(ModuleDeclaration decl) {
        ArrayList ndes;
        block4: {
            ndes = new ArrayList();
            try {
                decl.traverse(new ASTVisitor(){

                    public boolean visitGeneral(ASTNode node) throws Exception {
                        TclStatement st;
                        Expression cmd;
                        if (node instanceof TclStatement && ((TclStatement)node).getCount() > 2 && (cmd = (st = (TclStatement)node).getAt(0)) instanceof SimpleReference) {
                            Expression name;
                            String cmdName = ((SimpleReference)cmd).getName();
                            if (cmdName.startsWith("::")) {
                                cmdName = cmdName.substring(2);
                            }
                            if (("test".equals(cmdName) || "tcltest::test".equals(cmdName)) && (name = st.getAt(1)) instanceof SimpleReference) {
                                ((SimpleReference)name).getName();
                                ndes.add(node);
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return ndes.toArray(new ASTNode[ndes.size()]);
    }

    public void correctLaunchConfiguration(InterpreterConfig config, ILaunchConfiguration configuration, ILaunch launch) {
        block3: {
            try {
                IDeployment deployment = config.getExecutionEnvironment().createDeployment();
                IPath runner = deployment.add(Activator.getDefault().getBundle(), "scripts/tcltestEngine.tcl");
                runner = new Path(deployment.getFile(runner).toOSString());
                IPath scriptFilePath = config.getScriptFilePath();
                config.setScriptFile(runner);
                if (scriptFilePath != null) {
                    config.addScriptArg(scriptFilePath.toOSString(), 0);
                }
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }
}

