/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.serialization;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.dltk.compiler.problem.DefaultProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.caching.AbstractDataLoader;
import org.eclipse.dltk.tcl.ast.AstFactory;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCodeModel;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.definitions.ComplexArgument;
import org.eclipse.dltk.tcl.definitions.Scope;
import org.eclipse.dltk.tcl.internal.core.serialization.ITclASTConstants;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class TclASTLoader
extends AbstractDataLoader
implements ITclASTConstants {
    private Scope[] scopes = DefinitionManager.getInstance().getScopes();
    int moduleSize = 0;

    public TclASTLoader(InputStream stream) throws IOException {
        super(stream);
    }

    public int readInt() throws IOException {
        if (this.moduleSize < 127) {
            return this.in.readByte();
        }
        if (this.moduleSize < Short.MAX_VALUE) {
            return this.in.readShort();
        }
        return this.in.readInt();
    }

    public TclModule getModule(IProblemReporter collector) throws Exception {
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        this.readStrings();
        byte moduleTag = this.in.readByte();
        switch (moduleTag) {
            case 0: {
                TclModule module = AstFactory.eINSTANCE.createTclModule();
                this.moduleSize = this.in.readInt();
                module.setSize(this.moduleSize);
                EList<TclCommand> statements = module.getStatements();
                int statemetsSize = this.in.readInt();
                int i = 0;
                while (i < statemetsSize) {
                    statements.add((Object)this.readCommand());
                    ++i;
                }
                boolean hasCodeModel = this.in.readBoolean();
                if (hasCodeModel) {
                    TclCodeModel codeModel = AstFactory.eINSTANCE.createTclCodeModel();
                    module.setCodeModel(codeModel);
                    int delimSize = this.in.readInt();
                    EList<String> delimList = codeModel.getDelimeters();
                    int i2 = 0;
                    while (i2 < delimSize) {
                        delimList.add((Object)this.readString());
                        ++i2;
                    }
                    int offsets = this.in.readInt();
                    EList<Integer> offList = codeModel.getLineOffsets();
                    int i3 = 0;
                    while (i3 < offsets) {
                        offList.add((Object)this.readInt());
                        ++i3;
                    }
                }
                int problemsSize = this.in.readInt();
                int i4 = 0;
                while (i4 < problemsSize) {
                    this.loadProblem(collector);
                    ++i4;
                }
                p.done("Tcl", "Load persisted AST", 0L);
                return module;
            }
        }
        p.done("Tcl", "Load persisted AST", 0L);
        return null;
    }

    private void loadProblem(IProblemReporter collector) throws IOException {
        byte tag = this.in.readByte();
        if (tag != 8) {
            return;
        }
        int id = this.in.readInt();
        String message = this.readString();
        int start = this.readInt();
        int end = this.readInt() + start;
        int argsSize = this.in.readInt();
        String[] args = null;
        if (argsSize > 0) {
            args = new String[argsSize];
        }
        int i = 0;
        while (i < argsSize) {
            args[i] = this.readString();
            ++i;
        }
        boolean error = this.in.readBoolean();
        boolean warning = this.in.readBoolean();
        int lineNumber = this.readInt();
        int sev = 0;
        if (error) {
            sev = 1;
        } else if (warning) {
            sev = 0;
        }
        DefaultProblemFactory fact = new DefaultProblemFactory();
        IProblem problem = fact.createProblem(null, id, args, new String[]{message}, sev, start, end, lineNumber, 0);
        collector.reportProblem(problem);
    }

    public TclArgument readArgument() throws IOException {
        byte argType = this.in.readByte();
        switch (argType) {
            case 2: {
                StringArgument argument = AstFactory.eINSTANCE.createStringArgument();
                argument.setStart(this.readInt());
                argument.setEnd(this.readInt() + argument.getStart());
                argument.setValue(this.readString());
                return argument;
            }
            case 3: {
                ComplexString carg = AstFactory.eINSTANCE.createComplexString();
                carg.setKind(this.in.readInt());
                carg.setStart(this.readInt());
                carg.setEnd(this.readInt() + carg.getStart());
                EList<TclArgument> eList = carg.getArguments();
                int size = this.in.readInt();
                int i = 0;
                while (i < size) {
                    eList.add((Object)this.readArgument());
                    ++i;
                }
                return carg;
            }
            case 4: {
                Script st = AstFactory.eINSTANCE.createScript();
                EList<TclCommand> eList = st.getCommands();
                st.setStart(this.readInt());
                st.setEnd(this.readInt() + st.getStart());
                st.setContentStart(this.readInt());
                st.setContentEnd(this.readInt() + st.getContentStart());
                int size = this.in.readInt();
                int i = 0;
                while (i < size) {
                    eList.add((Object)this.readCommand());
                    ++i;
                }
                return st;
            }
            case 6: {
                VariableReference var = AstFactory.eINSTANCE.createVariableReference();
                var.setStart(this.readInt());
                var.setEnd(this.readInt() + var.getStart());
                var.setName(this.readString());
                boolean index = this.in.readBoolean();
                if (index) {
                    var.setIndex(this.readArgument());
                }
                return var;
            }
            case 5: {
                Substitution st = AstFactory.eINSTANCE.createSubstitution();
                EList<TclCommand> eList = st.getCommands();
                st.setStart(this.readInt());
                st.setEnd(this.readInt() + st.getStart());
                int size = this.in.readInt();
                int i = 0;
                while (i < size) {
                    eList.add((Object)this.readCommand());
                    ++i;
                }
                return st;
            }
            case 7: {
                TclArgumentList st = AstFactory.eINSTANCE.createTclArgumentList();
                st.setKind(this.in.readInt());
                st.setStart(this.readInt());
                st.setEnd(this.readInt() + st.getStart());
                EList<TclArgument> arguments = st.getArguments();
                int size = this.in.readInt();
                int i = 0;
                while (i < size) {
                    arguments.add((Object)this.readArgument());
                    ++i;
                }
                EObject def = this.restoreERef();
                if (def instanceof ComplexArgument) {
                    st.setDefinitionArgument((ComplexArgument)def);
                }
                return st;
            }
        }
        throw new IOException("Failed to load command argument.");
    }

    public TclCommand readCommand() throws IOException {
        byte tagCommand = this.in.readByte();
        if (tagCommand != 1) {
            throw new IOException("Incorrect command tag");
        }
        TclCommand command = AstFactory.eINSTANCE.createTclCommand();
        command.setStart(this.readInt());
        command.setEnd(this.readInt() + command.getStart());
        command.setQualifiedName(this.readString());
        EObject def = this.restoreERef();
        if (def instanceof Command) {
            command.setDefinition((Command)def);
        }
        command.setName(this.readArgument());
        int size = this.in.readInt();
        EList<TclArgument> eList = command.getArguments();
        int i = 0;
        while (i < size) {
            eList.add((Object)this.readArgument());
            ++i;
        }
        return command;
    }

    private EObject restoreERef() throws IOException {
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        EObject def = null;
        boolean has = this.in.readBoolean();
        if (!has) {
            return null;
        }
        String definitionURI = this.readString();
        if (definitionURI != null) {
            Scope[] scopeArray = this.scopes;
            int n = this.scopes.length;
            int n2 = 0;
            while (n2 < n) {
                Scope scope = scopeArray[n2];
                Resource eResource = scope.eResource();
                URI frag = eResource.getURI().appendFragment(definitionURI);
                EObject eObject = DefinitionManager.getInstance().getEobjectCache().get(frag);
                if (eObject != null) {
                    return eObject;
                }
                ++n2;
            }
        }
        p.done("Tcl", "Restore eREF", 0L);
        return def;
    }
}

