/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.navigation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageElement;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageFragment;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesElement;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesFragment;
import org.eclipse.dltk.ui.IModelContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class TclModelContentProvider
implements IModelContentProvider {
    public void provideModelChanges(Object parentElement, List children, ITreeContentProvider iTreeContentProvider) {
        block16: {
            block15: {
                if (parentElement instanceof BuildPathContainer) {
                    BuildPathContainer container = (BuildPathContainer)parentElement;
                    IBuildpathEntry entry = container.getBuildpathEntry();
                    if (!entry.getPath().segment(0).equals(ScriptRuntime.INTERPRETER_CONTAINER)) {
                        return;
                    }
                    IScriptProject project = container.getScriptProject();
                    try {
                        IProjectFragment[] fragments = project.getProjectFragments();
                        int i = 0;
                        while (i < fragments.length) {
                            if (fragments[i] instanceof TclPackageFragment) {
                                TclPackageFragment fragment = (TclPackageFragment)fragments[i];
                                children.addAll((Collection)Arrays.asList(fragment.getChildren()));
                            }
                            ++i;
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block15;
                        e.printStackTrace();
                    }
                }
            }
            if (parentElement instanceof IScriptProject) {
                IScriptProject prj = (IScriptProject)parentElement;
                IProjectFragment[] fragments = null;
                try {
                    fragments = prj.getProjectFragments();
                }
                catch (ModelException e) {
                    DLTKCore.error((String)"Error resolving project fragments", (Throwable)e);
                }
                int i = 0;
                while (i < fragments.length) {
                    TclSourcesFragment fragment;
                    if (fragments[i] instanceof TclSourcesFragment && (fragment = (TclSourcesFragment)fragments[i]).containChildrens()) {
                        children.add(fragment);
                    }
                    ++i;
                }
            }
            if (parentElement instanceof TclSourcesFragment) {
                TclSourcesFragment fragment = (TclSourcesFragment)parentElement;
                children.clear();
                try {
                    IModelElement[] elements = fragment.getChildren();
                    TclSourcesElement element = (TclSourcesElement)elements[0];
                    IModelElement[] modelElements = element.getChildren();
                    int i = 0;
                    while (i < modelElements.length) {
                        children.add(modelElements[i]);
                        ++i;
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block16;
                    e.printStackTrace();
                }
            }
        }
    }

    public Object getParentElement(Object element, ITreeContentProvider iTreeContentProvider) {
        if (element instanceof TclPackageFragment || element instanceof TclPackageElement) {
            IScriptProject project = ((IModelElement)element).getScriptProject();
            Object[] children = iTreeContentProvider.getChildren((Object)project);
            int i = 0;
            while (i < children.length) {
                BuildPathContainer container;
                IBuildpathEntry entry;
                if (children[i] instanceof BuildPathContainer && (entry = (container = (BuildPathContainer)children[i]).getBuildpathEntry()).getPath().segment(0).equals(ScriptRuntime.INTERPRETER_CONTAINER)) {
                    return container;
                }
                ++i;
            }
        }
        return null;
    }
}

