/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackagesFactory;
import org.eclipse.dltk.tcl.core.packages.TclProjectInfo;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.text.SourcesSelectionDialog;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IAnnotationResolution;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;

final class TclSourceCorrectionMarkerResolution
implements IMarkerResolution,
IAnnotationResolution {
    private String sourceName;
    private IScriptProject project;
    private ISourceModule module;

    public TclSourceCorrectionMarkerResolution(String pkgName, IScriptProject scriptProject, ISourceModule module) {
        this.sourceName = pkgName;
        this.project = scriptProject;
        this.module = module;
    }

    public String getLabel() {
        return "Add user specified source file location to buildpath";
    }

    private boolean resolve() {
        try {
            IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.project);
            if (install != null) {
                IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)this.module);
                SourcesSelectionDialog dialog = new SourcesSelectionDialog((IShellProvider)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getWorkbenchWindow(), env);
                if (dialog.open() == 0) {
                    String handle;
                    String[] sources = dialog.getSources();
                    TclProjectInfo tclProject = TclPackagesManager.getTclProject((String)this.project.getElementName());
                    TclModuleInfo info = tclProject.findModule(handle = this.module.getHandleIdentifier());
                    if (info == null) {
                        info = TclPackagesFactory.eINSTANCE.createTclModuleInfo();
                        info.setHandle(handle);
                        info.setExternal(this.module instanceof IExternalSourceModule);
                        TclSourceEntry sourceEntry = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
                        sourceEntry.setStart(-1);
                        sourceEntry.setEnd(-1);
                        sourceEntry.setValue(this.sourceName);
                        info.getSourced().add((Object)sourceEntry);
                        tclProject.getModules().add((Object)info);
                    }
                    UserCorrection correction = TclPackagesFactory.eINSTANCE.createUserCorrection();
                    info.getSourceCorrections().add((Object)correction);
                    correction.setOriginalValue(this.sourceName);
                    correction.getUserValue().addAll((Collection)Arrays.asList(sources));
                    TclPackagesManager.save();
                    ModelManager.getModelManager().getDeltaProcessor().checkExternalChanges(new IModelElement[]{this.project}, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (CoreException e) {
            TclUI.error("require package resolve error", e);
        }
        return false;
    }

    public void run(IMarker marker) {
        this.resolve();
    }

    public void run(IScriptAnnotation annotation, IDocument document) {
        this.resolve();
    }
}

