/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IType;

public class CumulativeType {
    private final String qName;
    private final IType[] types;

    public CumulativeType(String qName, IType[] types) {
        this.qName = qName;
        this.types = types;
        Assert.isTrue((types != null && types.length != 0 ? 1 : 0) != 0);
    }

    public IType getFirst() {
        return this.types[0];
    }

    public boolean contains(Object input) {
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equals(input)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IType[] getTypes() {
        return this.types;
    }

    public void insertTo(List list, int index) {
        int i = 0;
        while (i < this.types.length) {
            list.add(index, new Part(this.types[i]));
            ++i;
        }
    }

    public int hashCode() {
        return this.qName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CumulativeType) {
            return this.qName.equals(((CumulativeType)obj).qName);
        }
        return false;
    }

    public class Part {
        public final IType type;

        public Part(IType type) {
            this.type = type;
        }

        public CumulativeType getParent() {
            return CumulativeType.this;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Part) {
                return this.type.equals(((Part)obj).type);
            }
            return false;
        }
    }
}

