/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class BPListElementSorter
extends ViewerSorter {
    private static final int SOURCE = 0;
    private static final int PROJECT = 1;
    private static final int LIBRARY = 2;
    private static final int CONTAINER = 3;
    private static final int ATTRIBUTE = 5;
    private static final int CONTAINER_ENTRY = 6;
    private static final int OTHER = 7;

    public int category(Object obj) {
        if (obj instanceof BPListElement) {
            BPListElement element = (BPListElement)obj;
            if (element.getParentContainer() != null) {
                return 6;
            }
            switch (element.getEntryKind()) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 5: {
                    return 3;
                }
            }
        } else {
            if (obj instanceof BPListElementAttribute) {
                return 5;
            }
            if (obj instanceof IAccessRule) {
                return 5;
            }
        }
        return 7;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        IBaseLabelProvider prov;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (cat1 == 5 || cat1 == 6) {
            return 0;
        }
        if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            ILabelProvider lprov = (ILabelProvider)prov;
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            return this.getComparator().compare(name1, name2);
        }
        return 0;
    }
}

