/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ConfigureBuildPathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private IProject fProject;

    public ConfigureBuildPathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ConfigureBP_label, DLTKPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ConfigureBP_tooltip);
        this.setDisabledImageDescriptor(DLTKPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH);
        this.fSite = site;
    }

    private Shell getShell() {
        return this.fSite.getShell();
    }

    public void run() {
        if (this.fProject != null) {
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, null, null, null);
            List elements = dialog.getPreferenceManager().getElements(0);
            for (IPreferenceNode node : elements) {
                String nodeId = node.getId();
                if (!nodeId.endsWith("BuildpathProperties")) continue;
                dialog.close();
                dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, (String)nodeId, null, null);
                break;
            }
            dialog.open();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() != 1) {
            return false;
        }
        Object firstElement = elements.getFirstElement();
        this.fProject = this.getProjectFromSelectedElement(firstElement);
        return this.fProject != null;
    }

    private IProject getProjectFromSelectedElement(Object firstElement) {
        IResource res;
        if (firstElement instanceof IModelElement) {
            IModelElement element = (IModelElement)firstElement;
            IProjectFragment root = ScriptModelUtil.getProjectFragment((IModelElement)element);
            if (root != null && root != element && root.isArchive()) {
                return null;
            }
            IScriptProject project = element.getScriptProject();
            if (project != null) {
                return project.getProject();
            }
            return null;
        }
        if (firstElement instanceof BuildPathContainer) {
            return ((BuildPathContainer)firstElement).getScriptProject().getProject();
        }
        if (firstElement instanceof IAdaptable && (res = (IResource)((IAdaptable)firstElement).getAdapter(IResource.class)) != null) {
            return res.getProject();
        }
        return null;
    }
}

