/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class OthersWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String ID = "org.eclipse.dltk.internal.ui.OthersWorkingSet";
    private IWorkingSet fWorkingSet;
    private WorkingSetModel fWorkingSetModel;
    private IResourceChangeListener fResourceChangeListener;
    private IPropertyChangeListener fWorkingSetListener;
    private IElementChangedListener fScriptElementChangeListener;

    public void add(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == null && this.fWorkingSetModel != null ? 1 : 0) != 0);
        this.fWorkingSet = workingSet;
    }

    public boolean remove(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == workingSet ? 1 : 0) != 0);
        this.fWorkingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet workingSet) {
        return this.fWorkingSet == workingSet;
    }

    public void init(WorkingSetModel model) {
        this.fWorkingSetModel = model;
        this.fResourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener, 1);
        this.fWorkingSetListener = new WorkingSetListener();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.fWorkingSetListener);
        this.fScriptElementChangeListener = new ScriptElementChangeListener();
        DLTKCore.addElementChangedListener((IElementChangedListener)this.fScriptElementChangeListener, (int)1);
    }

    public void dispose() {
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
        if (this.fScriptElementChangeListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fScriptElementChangeListener);
        }
    }

    public void updateElements() {
        Assert.isTrue((this.fWorkingSet != null && this.fWorkingSetModel != null ? 1 : 0) != 0);
        IWorkingSet[] activeWorkingSets = this.fWorkingSetModel.getActiveWorkingSets();
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet<IResource> projects = new HashSet<IResource>();
        int i = 0;
        while (i < activeWorkingSets.length) {
            if (activeWorkingSets[i] != this.fWorkingSet) {
                IAdaptable[] elements = activeWorkingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IAdaptable element = elements[j];
                    IResource resource = (IResource)element.getAdapter(IResource.class);
                    if (resource != null && resource.getType() == 4) {
                        projects.add(resource);
                    }
                    ++j;
                }
            }
            ++i;
        }
        IScriptModel model = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            IScriptProject[] jProjects = model.getScriptProjects();
            int i2 = 0;
            while (i2 < jProjects.length) {
                if (!projects.contains(jProjects[i2].getProject())) {
                    result.add(jProjects[i2]);
                }
                ++i2;
            }
            Object[] rProjects = model.getForeignResources();
            int i3 = 0;
            while (i3 < rProjects.length) {
                if (!projects.contains(rProjects[i3])) {
                    result.add(rProjects[i3]);
                }
                ++i3;
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        this.fWorkingSet.setElements(result.toArray(new IAdaptable[result.size()]));
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (OthersWorkingSetUpdater.this.fWorkingSet == null) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(3, 4);
            if (affectedChildren.length > 0) {
                OthersWorkingSetUpdater.this.updateElements();
            } else {
                affectedChildren = delta.getAffectedChildren(4, 4);
                int i = 0;
                while (i < affectedChildren.length) {
                    IResourceDelta projectDelta = affectedChildren[i];
                    if ((projectDelta.getFlags() & 0x80000) != 0) {
                        OthersWorkingSetUpdater.this.updateElements();
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private class ScriptElementChangeListener
    implements IElementChangedListener {
        private ScriptElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (OthersWorkingSetUpdater.this.fWorkingSet == null) {
                return;
            }
            this.processScriptDelta(new ArrayList(Arrays.asList(OthersWorkingSetUpdater.this.fWorkingSet.getElements())), event.getDelta());
        }

        private void processScriptDelta(List elements, IModelElementDelta delta) {
            IModelElement jElement = delta.getElement();
            int type = jElement.getElementType();
            if (type == 2) {
                int index = elements.indexOf(jElement);
                int kind = delta.getKind();
                int flags = delta.getFlags();
                if (kind == 4) {
                    if (index != -1 && (flags & 0x400) != 0) {
                        elements.set(index, ((IScriptProject)jElement).getProject());
                        OthersWorkingSetUpdater.this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
                    } else if ((flags & 0x200) != 0 && (index = elements.indexOf(((IScriptProject)jElement).getProject())) != -1) {
                        elements.set(index, jElement);
                        OthersWorkingSetUpdater.this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
                    }
                }
                return;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.processScriptDelta(elements, children[i]);
                ++i;
            }
        }
    }

    private class WorkingSetListener
    implements IPropertyChangeListener {
        private WorkingSetListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            IWorkingSet changedWorkingSet;
            if ("workingSetContentChange".equals(event.getProperty()) && (changedWorkingSet = (IWorkingSet)event.getNewValue()) != OthersWorkingSetUpdater.this.fWorkingSet && OthersWorkingSetUpdater.this.fWorkingSetModel.isActiveWorkingSet(changedWorkingSet)) {
                OthersWorkingSetUpdater.this.updateElements();
            }
        }
    }
}

