/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.templates;

import java.util.Iterator;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.ui.text.templates.TemplateVariableProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class TemplateVariableTextHover
implements ITextHover {
    private TemplateVariableProcessor fProcessor;

    public TemplateVariableTextHover(TemplateVariableProcessor processor) {
        this.fProcessor = processor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion subject) {
        try {
            IDocument doc = textViewer.getDocument();
            int offset = subject.getOffset();
            if (offset >= 2 && "${".equals(doc.get(offset - 2, 2))) {
                String varName = doc.get(offset, subject.getLength());
                TemplateContextType contextType = this.fProcessor.getContextType();
                if (contextType != null) {
                    Iterator iter = contextType.resolvers();
                    while (iter.hasNext()) {
                        TemplateVariableResolver var = (TemplateVariableResolver)iter.next();
                        if (!varName.equals(var.getType())) continue;
                        return var.getDescription();
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            return ScriptWordFinder.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }
}

