/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.expressions;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class UnaryExpression
extends Expression {
    protected Statement expression;
    protected int kind;

    public UnaryExpression(int start, int end, int knd, Statement expression) {
        super(start, end);
        this.kind = knd;
        this.expression = expression;
    }

    public UnaryExpression(DLTKToken t, int knd, Expression expression) {
        super(t);
        if (expression != null) {
            this.setEnd(expression.sourceEnd());
        }
        this.kind = knd;
        this.expression = expression;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            if (this.expression != null) {
                this.expression.traverse(pVisitor);
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    public int getKind() {
        return this.kind;
    }

    public Statement getExpression() {
        return this.expression;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn(this.getOperator());
        if (this.expression != null) {
            this.expression.printNode(output);
        }
    }
}

