/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.Type;

public class NodeFinder
extends ASTVisitor {
    final int start;
    final int end;
    ASTNode before = null;
    ASTNode after = null;

    public NodeFinder(String content, int position) {
        int start = position;
        while (start > 0 && (content.charAt(start - 1) == ' ' || content.charAt(start - 1) == '\t')) {
            --start;
        }
        this.start = start;
        int end = position;
        while (end < content.length() && Character.isWhitespace(content.charAt(end))) {
            ++end;
        }
        this.end = end;
    }

    private static boolean isBlock(ASTNode node) {
        return node instanceof Script || node instanceof FunctionStatement || node instanceof Statement;
    }

    public boolean visit(ASTNode node) {
        if (NodeFinder.isBlock(node)) {
            if (node.sourceEnd() < this.start || node.sourceStart() > this.end) {
                return false;
            }
            return node.sourceEnd() != this.start || !(node instanceof ISemicolonStatement) || ((ISemicolonStatement)node).getSemicolonPosition() < 0;
        }
        boolean enter = false;
        if (this.before == null || NodeFinder.isCloser(node, this.before, this.start)) {
            this.before = node;
            enter = true;
        }
        if (this.after == null || NodeFinder.isCloser(node, this.after, this.end)) {
            this.after = node;
            enter = true;
        }
        return enter;
    }

    private static boolean isCloser(ASTNode node, ASTNode result, int pos) {
        return node.sourceStart() >= result.sourceStart() && node.sourceStart() <= pos;
    }

    private boolean traverse(Script script) {
        this.after = null;
        this.before = null;
        try {
            script.traverse((ASTVisitor)this);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Type locateType(Script script) {
        if (!this.traverse(script)) {
            return null;
        }
        if (this.isValid(this.before) && this.before instanceof Type) {
            return (Type)this.before;
        }
        if (this.isValid(this.after) && this.after instanceof Type) {
            return (Type)this.after;
        }
        return null;
    }

    public ASTNode locateNode(Script script) {
        if (!this.traverse(script)) {
            return null;
        }
        if (this.isValid(this.before)) {
            return this.before;
        }
        if (this.isValid(this.after)) {
            return this.after;
        }
        return null;
    }

    private boolean isValid(ASTNode n) {
        return n != null && n.sourceStart() <= this.end && n.sourceEnd() >= this.start;
    }
}

