/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.testing.model.TestElement;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.dltk.internal.testing.util.LegacyTestElementResolver;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.ITestElementResolver;
import org.eclipse.dltk.testing.TestElementResolution;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTestAction
extends Action {
    private final TestElement fTestElement;
    protected TestRunnerViewPart fTestRunner;
    private final boolean fActivate;

    protected OpenTestAction(TestRunnerViewPart testRunner, TestElement testElement) {
        this(testRunner, testElement, true);
    }

    public OpenTestAction(TestRunnerViewPart testRunner, TestElement testElement, boolean activate) {
        super(DLTKTestingMessages.OpenEditorAction_action_label);
        this.fTestElement = testElement;
        this.fTestRunner = testRunner;
        this.fActivate = activate;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.dltk.testing.open_test_action_context");
    }

    public void run() {
        ITestElementResolver resolver = this.acquireResolver();
        TestElementResolution resolution = resolver.resolveElement(this.fTestElement);
        if (resolution == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)DLTKTestingMessages.OpenEditorAction_error_cannotopen_title, (String)DLTKTestingMessages.OpenEditorAction_error_cannotopen_message);
            return;
        }
        try {
            ITextEditor textEditor = (ITextEditor)DLTKUIPlugin.openInEditor((IModelElement)resolution.getElement(), (boolean)this.fActivate, (boolean)false);
            if (textEditor != null) {
                ISourceRange range = resolution.getRange();
                if (range != null) {
                    textEditor.selectAndReveal(range.getOffset(), range.getLength());
                }
            } else {
                this.fTestRunner.registerInfoMessage(DLTKTestingMessages.OpenEditorAction_message_cannotopen);
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)DLTKTestingMessages.OpenEditorAction_error_dialog_title, (String)DLTKTestingMessages.OpenEditorAction_error_dialog_message, (IStatus)e.getStatus());
        }
    }

    private ITestElementResolver acquireResolver() {
        ITestElementResolver resolver = (ITestElementResolver)this.fTestRunner.getTestRunnerUI().getAdapter(ITestElementResolver.class);
        if (resolver != null) {
            return resolver;
        }
        return new LegacyTestElementResolver(this.getLaunchedProject(), this.fTestRunner.getLaunch().getLaunchConfiguration());
    }

    protected Shell getShell() {
        return this.fTestRunner.getSite().getShell();
    }

    protected IScriptProject getLaunchedProject() {
        return this.fTestRunner.getLaunchedProject();
    }

    protected TestElement getTestElement() {
        return this.fTestElement;
    }
}

