/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.builder.AbstractBuildChange;
import org.eclipse.dltk.internal.core.builder.BuildChange;
import org.eclipse.dltk.internal.core.builder.BuildStateStub;
import org.eclipse.dltk.internal.core.builder.FullBuildChange;
import org.eclipse.dltk.internal.core.builder.IncrementalBuildChange;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.internal.core.builder.ScriptBuilder;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalScriptBuilder
extends ScriptBuilder {
    LocalScriptBuilder() {
    }

    public void build(IProject project, List<IFile> files, IProgressMonitor monitor) {
        this.currentProject = project;
        this.scriptProject = (ScriptProject)DLTKCore.create(project);
        BuildStateStub buildState = new BuildStateStub(project.getName());
        IScriptBuilder[] builders = null;
        try {
            monitor.setTaskName(NLS.bind((String)Messages.ScriptBuilder_buildingScriptsIn, (Object)this.currentProject.getName()));
            monitor.beginTask("", 100);
            builders = this.getScriptBuilders();
            if (builders == null || builders.length == 0) {
                return;
            }
            try {
                IScriptBuilder builder;
                AbstractBuildChange buildChange = new BuildChange(project, null, files, monitor);
                IScriptBuilder[] iScriptBuilderArray = builders;
                int n = builders.length;
                int n2 = 0;
                while (n2 < n) {
                    builder = iScriptBuilderArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    builder.prepare((IBuildChange)((Object)buildChange), buildState, monitor);
                    if (buildChange.getBuildType() == 1 && buildChange instanceof IncrementalBuildChange) {
                        buildChange = new FullBuildChange(this.currentProject, monitor);
                    }
                    ++n2;
                }
                iScriptBuilderArray = builders;
                n = builders.length;
                n2 = 0;
                while (n2 < n) {
                    builder = iScriptBuilderArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    builder.build((IBuildChange)((Object)buildChange), buildState, monitor);
                    ++n2;
                }
            }
            catch (CoreException e) {
                DLTKCore.error(e);
            }
        }
        finally {
            this.resetBuilders(builders, buildState, monitor);
            monitor.done();
        }
    }
}

