/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationListener;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.NoWatchExpressionResult;
import org.eclipse.dltk.internal.debug.core.model.ScriptWatchExpressionResult;

public class ScriptWatchExpressionDelegate
implements IWatchExpressionDelegate {
    protected static IScriptThread getScriptThread(Object context) {
        if (context instanceof IScriptThread) {
            return (IScriptThread)context;
        }
        if (context instanceof IScriptStackFrame) {
            return (IScriptThread)((IScriptStackFrame)context).getThread();
        }
        return null;
    }

    protected static IScriptStackFrame getStackFrame(IDebugElement context) {
        try {
            if (context instanceof IScriptThread) {
                IStackFrame[] frames = ((IScriptThread)context).getStackFrames();
                if (frames.length > 0) {
                    return (IScriptStackFrame)frames[0];
                }
            } else if (context instanceof IScriptStackFrame) {
                return (IScriptStackFrame)context;
            }
        }
        catch (DebugException debugException) {}
        return null;
    }

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        IScriptEvaluationEngine engine;
        IScriptThread thread = ScriptWatchExpressionDelegate.getScriptThread(context);
        IScriptStackFrame frame = ScriptWatchExpressionDelegate.getStackFrame(context);
        if (thread != null && frame != null && (engine = thread.getEvaluationEngine()) != null) {
            engine.asyncEvaluate(this.prepareExpression(expression), frame, this.createListener(listener, expression));
            return;
        }
        listener.watchEvaluationFinished((IWatchExpressionResult)new NoWatchExpressionResult(expression));
    }

    protected String prepareExpression(String expression) {
        return expression;
    }

    protected ListenerAdpater createListener(IWatchExpressionListener listener, String expression) {
        return new ListenerAdpater(listener);
    }

    protected static class ListenerAdpater
    implements IScriptEvaluationListener {
        protected final IWatchExpressionListener listener;

        public ListenerAdpater(IWatchExpressionListener listener) {
            this.listener = listener;
        }

        public void evaluationComplete(IScriptEvaluationResult result) {
            this.listener.watchEvaluationFinished((IWatchExpressionResult)new ScriptWatchExpressionResult(result));
        }
    }
}

