/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.structure;

import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.structure.IDeclaration;
import org.eclipse.dltk.javascript.structure.IParentNode;
import org.eclipse.dltk.javascript.structure.IStructureContext;
import org.eclipse.dltk.javascript.structure.IStructureNode;
import org.eclipse.dltk.javascript.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.structure.ParentNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

public class VariableNode
extends ParentNode
implements IDeclaration {
    private final IModelBuilder.IVariable variable;
    private final VariableDeclaration declaration;
    private IStructureNode value;

    public VariableNode(IParentNode parent, VariableDeclaration declaration, IModelBuilder.IVariable variable) {
        super(parent);
        this.declaration = declaration;
        this.variable = variable;
    }

    @Override
    public String getName() {
        return this.declaration.getVariableName();
    }

    @Override
    public JSType getType() {
        return this.variable.getType();
    }

    @Override
    public ReferenceLocation getLocation() {
        return this.variable.getLocation();
    }

    @Override
    public int start() {
        return this.getLocation().getDeclarationStart();
    }

    public IStructureNode getValue() {
        return this.value;
    }

    public void setValue(IStructureNode value) {
        this.value = value;
    }

    @Override
    public List<? extends IStructureNode> getChildren() {
        if (this.value != null && this.declaration.getInitializer() instanceof NewExpression && ((NewExpression)this.declaration.getInitializer()).getObjectClass() instanceof FunctionStatement) {
            return this.value.getChildren();
        }
        return this.value != null ? Collections.singletonList(this.value) : Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(":variable");
        if (this.value != null) {
            sb.append("=");
            sb.append(this.value);
        }
        return sb.toString();
    }

    @Override
    public void reportStructure(IStructureRequestor requestor, IStructureContext context) {
        boolean isField = context.allow(1);
        if (isField) {
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            info.declarationStart = this.declaration.start();
            info.name = this.getName();
            info.nameSourceStart = this.declaration.getIdentifier().start();
            info.nameSourceEnd = this.declaration.getIdentifier().end() - 1;
            info.type = this.typeToModel(this.variable.getType());
            if (this.variable.getVisibility() != null) {
                info.modifiers |= this.variable.getVisibility().getFlags();
            }
            if (this.variable.isDeprecated()) {
                info.modifiers |= 0x40000;
            }
            requestor.enterField(info, (Expression)this.declaration.getIdentifier(), this.variable.getType(), false);
        } else {
            requestor.enterLocal(this.declaration.getIdentifier(), this.variable.getType());
        }
        this.reportChildrenStructure(requestor, context);
        if (isField) {
            requestor.exitField(this.declaration.end() - 1);
        } else {
            requestor.exitLocal(this.declaration.end() - 1);
        }
    }
}

