/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IImportDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.ImportContainer;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.utils.CorePrinter;

public class ImportDeclaration
extends SourceRefElement
implements IImportDeclaration {
    private final String name;
    private final String version;

    protected ImportDeclaration(ImportContainer parent, String name, String version) {
        super(parent);
        this.name = name;
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ImportDeclaration)) {
            return false;
        }
        ImportDeclaration other = (ImportDeclaration)o;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int getElementType() {
        return 12;
    }

    @Override
    public void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        this.escapeMementoName(buff, this.getElementName());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    @Override
    public IModelElement getPrimaryElement(boolean checkOwner) {
        AbstractSourceModule cu = (AbstractSourceModule)this.parent.getParent();
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        return new ImportDeclaration(new ImportContainer(cu, ((ImportContainer)this.parent).getContainerName()), this.name, this.version);
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("import ");
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    @Override
    protected void closing(Object info) throws ModelException {
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint(this.getElementName());
    }

    @Override
    public ISourceRange getNameRange() throws ModelException {
        return this.getSourceRange();
    }
}

