/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.console;

import java.util.ArrayList;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.commands.actions.DebugCommandService;
import org.eclipse.dltk.debug.ui.ScriptDebugConsole;
import org.eclipse.dltk.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IUpdate;

public class ConsoleTerminateAction
extends Action
implements IUpdate {
    private ScriptDebugConsole fConsole;
    private IWorkbenchWindow fWindow;

    public ConsoleTerminateAction(IWorkbenchWindow window, ScriptDebugConsole console) {
        super(ConsoleMessages.ConsoleTerminateAction_0);
        this.fConsole = console;
        this.fWindow = window;
        this.setToolTipText(ConsoleMessages.ConsoleTerminateAction_1);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_TERMINATE"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_DLCL_TERMINATE"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_TERMINATE"));
        this.update();
    }

    public void update() {
        ILaunch launch = this.fConsole.getLaunch();
        this.setEnabled(launch.canTerminate());
    }

    public void run() {
        ArrayList<Object> targets = new ArrayList<Object>();
        ILaunch launch = this.fConsole.getLaunch();
        IDebugTarget[] debugTargets = launch.getDebugTargets();
        int k = 0;
        while (k < debugTargets.length) {
            targets.add(debugTargets[k]);
            ++k;
        }
        IProcess[] processes = launch.getProcesses();
        int k2 = 0;
        while (k2 < processes.length) {
            targets.add(processes[k2]);
            ++k2;
        }
        DebugCommandService service = DebugCommandService.getService((IWorkbenchWindow)this.fWindow);
        service.executeCommand(ITerminateHandler.class, targets.toArray(), null);
    }

    public void dispose() {
        this.fConsole = null;
    }
}

