/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.trace;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfThreadSelectedSignal;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceModelSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class LinuxTraceContext
extends TmfTraceContext {
    public static final int INVALID_CPU = -1;
    public static final int INVALID_THREAD_ID = -1;
    private final int fCpu;
    private final int fTid;
    private final ITmfTrace fTrace;

    public LinuxTraceContext(TmfTimeRange selection, TmfTimeRange windowRange, @Nullable IFile editorFile, @Nullable ITmfFilter filter, ITmfTrace trace) {
        super(selection, windowRange, editorFile, filter);
        this.fCpu = -1;
        this.fTid = -1;
        this.fTrace = trace;
    }

    public LinuxTraceContext(LinuxBuilder builder) {
        super((TmfTraceContext.Builder)builder);
        this.fCpu = builder.cpu;
        this.fTid = builder.tid;
        this.fTrace = builder.trace;
    }

    public void receive(@NonNull TmfTraceModelSignal signal) {
        if (signal.getHostId().equals(this.fTrace.getHostId())) {
            TmfTraceManager.getInstance().updateTraceContext(this.fTrace, builder -> {
                if (builder instanceof LinuxBuilder) {
                    if (signal instanceof TmfThreadSelectedSignal) {
                        ((LinuxBuilder)((Object)builder)).setTid(((TmfThreadSelectedSignal)signal).getThreadId());
                    } else if (signal instanceof TmfCpuSelectedSignal) {
                        ((LinuxBuilder)((Object)builder)).setCpu(((TmfCpuSelectedSignal)signal).getCore());
                    }
                }
                return builder;
            });
        }
    }

    public int getCpu() {
        return this.fCpu;
    }

    public int getTid() {
        return this.fTid;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TmfTraceContext.Builder builder() {
        return new LinuxBuilder(this);
    }

    public static class LinuxBuilder
    extends TmfTraceContext.Builder {
        private int cpu;
        private int tid;
        private ITmfTrace trace;

        public LinuxBuilder(LinuxTraceContext ctx) {
            super((TmfTraceContext)ctx);
            this.cpu = ctx.fCpu;
            this.tid = ctx.fTid;
            this.trace = ctx.fTrace;
        }

        public TmfTraceContext build() {
            return new LinuxTraceContext(this);
        }

        public TmfTraceContext.Builder setCpu(int cpu) {
            this.cpu = cpu;
            return this;
        }

        public TmfTraceContext.Builder setTid(int tid) {
            this.tid = tid;
            return this;
        }
    }
}

