/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.AgentFromInstall;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;

public class PreviousConfigurationFinder {
    private static final Pattern path = Pattern.compile("(.+?)_{1}?([0-9\\.]+)_{1}?(\\d+)(_*?([^_].*)|$)");
    private final File currentConfig;

    public PreviousConfigurationFinder(File currentConfiguration) {
        this.currentConfig = currentConfiguration;
    }

    public ConfigurationDescriptor extractConfigurationData(File candidate) {
        Matcher m = path.matcher(candidate.getName());
        if (!m.matches()) {
            return null;
        }
        return new ConfigurationDescriptor(m.group(1), new Identifier(m.group(2)), m.group(3), m.group(5), candidate.getAbsoluteFile());
    }

    public IProvisioningAgent findPreviousInstalls(File searchRoot, File installFolder) {
        List<ConfigurationDescriptor> potentialConfigurations = this.readPreviousConfigurations(searchRoot);
        ConfigurationDescriptor runningConfiguration = this.getConfigdataFromProductFile(installFolder);
        if (runningConfiguration == null) {
            return null;
        }
        ConfigurationDescriptor match = this.findMostRelevantConfigurationFromInstallHashDir(potentialConfigurations, runningConfiguration);
        if (match == null) {
            match = this.findMostRelevantConfigurationFromProductId(potentialConfigurations, runningConfiguration);
        }
        if (match == null) {
            match = this.findSpecifiedConfiguration(searchRoot);
        }
        if (match == null) {
            return null;
        }
        return AgentFromInstall.createAgentFrom((IProvisioningAgentProvider)AutomaticUpdatePlugin.getDefault().getAgentProvider(), null, (File)new File(match.getConfig(), "configuration"), null);
    }

    public ConfigurationDescriptor findSpecifiedConfiguration(File searchRoot) {
        String[] prefixes;
        String prefixesAsString = System.getProperty("p2.forcedMigrationLocation");
        if (prefixesAsString == null) {
            return null;
        }
        String[] stringArray = prefixes = prefixesAsString.split(",");
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String p = prefix;
            File[] match = searchRoot.listFiles(candidate -> {
                if (!candidate.isDirectory()) {
                    return false;
                }
                if (this.currentConfig.equals(candidate)) {
                    return false;
                }
                return candidate.getName().contains(p);
            });
            if (match.length != 0) {
                return new ConfigurationDescriptor("unknown", new Identifier("0.0.0"), "unknown", "unknown", match[0]);
            }
            ++n2;
        }
        return null;
    }

    private ConfigurationDescriptor getConfigdataFromProductFile(File installFolder) {
        Object[] productFileInfo = this.loadEclipseProductFile(installFolder);
        if (productFileInfo.length == 0) {
            return null;
        }
        return new ConfigurationDescriptor((String)productFileInfo[0], (Identifier)productFileInfo[1], this.getInstallDirHash(installFolder), Platform.getOS() + "_" + Platform.getWS() + "_" + Platform.getOSArch(), null);
    }

    public ConfigurationDescriptor findMostRelevantConfigurationFromInstallHashDir(List<ConfigurationDescriptor> configurations, ConfigurationDescriptor configToMatch) {
        ConfigurationDescriptor bestMatch = null;
        int numberOfcriteriaMet = 0;
        for (ConfigurationDescriptor candidate : configurations) {
            int criteriaMet = 0;
            if (!candidate.getInstallPathHashcode().equals(configToMatch.getInstallPathHashcode())) continue;
            ++criteriaMet;
            if (configToMatch.getProductId().equals(candidate.getProductId()) && configToMatch.getPlatformConfig().equals(candidate.getPlatformConfig()) && !candidate.getVersion().isGreaterEqualTo(configToMatch.getVersion())) {
                ++criteriaMet;
            }
            if (criteriaMet == 0) continue;
            if (criteriaMet > numberOfcriteriaMet) {
                bestMatch = candidate;
                numberOfcriteriaMet = criteriaMet;
                continue;
            }
            if (criteriaMet != numberOfcriteriaMet) continue;
            if (bestMatch.getVersion().equals(candidate.getVersion())) {
                if (bestMatch.getConfig().lastModified() >= candidate.getConfig().lastModified()) continue;
                bestMatch = candidate;
                continue;
            }
            if (!candidate.getVersion().isGreaterEqualTo(bestMatch.getVersion())) continue;
            bestMatch = candidate;
        }
        return bestMatch;
    }

    public ConfigurationDescriptor findMostRelevantConfigurationFromProductId(List<ConfigurationDescriptor> configurations, ConfigurationDescriptor configToMatch) {
        ConfigurationDescriptor bestMatch = null;
        ArrayList<ConfigurationDescriptor> candidates = new ArrayList<ConfigurationDescriptor>();
        ArrayList<ConfigurationDescriptor> candidatesWithUnkonwArchitecture = new ArrayList<ConfigurationDescriptor>();
        for (ConfigurationDescriptor candidate : configurations) {
            if (!configToMatch.getProductId().equals(candidate.getProductId()) || !configToMatch.getVersion().isGreaterEqualTo(candidate.getVersion())) continue;
            if (configToMatch.getPlatformConfig().equals(candidate.getPlatformConfig())) {
                candidates.add(candidate);
                continue;
            }
            candidatesWithUnkonwArchitecture.add(candidate);
        }
        if (!candidates.isEmpty()) {
            candidates.sort(new ConfigurationDescriptorComparator());
            bestMatch = (ConfigurationDescriptor)candidates.get(candidates.size() - 1);
        }
        if (bestMatch == null && !candidatesWithUnkonwArchitecture.isEmpty()) {
            candidatesWithUnkonwArchitecture.sort(new ConfigurationDescriptorComparator());
            bestMatch = (ConfigurationDescriptor)candidatesWithUnkonwArchitecture.get(candidatesWithUnkonwArchitecture.size() - 1);
        }
        return bestMatch;
    }

    private Object[] loadEclipseProductFile(File installDir) {
        Identifier appVersion;
        String appId;
        block13: {
            String ECLIPSE = "eclipse";
            String PRODUCT_SITE_MARKER = ".eclipseproduct";
            String PRODUCT_SITE_ID = "id";
            String PRODUCT_SITE_VERSION = "version";
            File eclipseProduct = new File(installDir, ".eclipseproduct");
            appId = null;
            appVersion = null;
            if (eclipseProduct.exists()) {
                Properties props = new Properties();
                try {
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (FileInputStream is = new FileInputStream(eclipseProduct);){
                        String version;
                        props.load(is);
                        appId = props.getProperty("id");
                        if (appId == null || appId.trim().length() == 0) {
                            appId = "eclipse";
                        }
                        appVersion = (version = props.getProperty("version")) == null || version.trim().length() == 0 ? new Identifier(0, 0, 0) : new Identifier(version);
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    return new String[0];
                }
            }
            return new String[0];
        }
        return new Object[]{appId, appVersion};
    }

    public List<ConfigurationDescriptor> readPreviousConfigurations(File configurationFolder) {
        File[] candidates = configurationFolder.listFiles();
        ArrayList<ConfigurationDescriptor> configurations = new ArrayList<ConfigurationDescriptor>(candidates.length);
        File[] fileArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationDescriptor tmp;
            File candidate = fileArray[n2];
            if (candidate.isDirectory() && !candidate.equals(this.currentConfig) && (tmp = this.extractConfigurationData(candidate)) != null) {
                configurations.add(tmp);
            }
            ++n2;
        }
        return configurations;
    }

    private String getInstallDirHash(File installFolder) {
        try {
            return Integer.toString(installFolder.getCanonicalPath().hashCode());
        }
        catch (IOException e) {
            return "";
        }
    }

    public static class ConfigurationDescriptor {
        String productId;
        Identifier version;
        String installPathHashcode;
        File configFolder;
        String os_ws_arch;

        public ConfigurationDescriptor(String productId, Identifier version, String installPathHashcode, String platformConfig, File configFolder) {
            this.productId = productId;
            this.version = version;
            this.installPathHashcode = installPathHashcode;
            this.configFolder = configFolder;
            this.os_ws_arch = platformConfig;
        }

        public String getProductId() {
            return this.productId;
        }

        public Identifier getVersion() {
            return this.version;
        }

        public String getInstallPathHashcode() {
            return this.installPathHashcode;
        }

        public File getConfig() {
            return this.configFolder;
        }

        public String getPlatformConfig() {
            return this.os_ws_arch;
        }
    }

    public static class ConfigurationDescriptorComparator
    implements Comparator<ConfigurationDescriptor> {
        @Override
        public int compare(ConfigurationDescriptor o1, ConfigurationDescriptor o2) {
            int result = -1;
            if (o1 != null && o2 != null) {
                result = o1.getVersion().compareTo(o2.getVersion()) != 0 ? o1.getVersion().compareTo(o2.getVersion()) : (o1.getConfig().lastModified() > o2.getConfig().lastModified() ? 1 : (o1.getConfig().lastModified() < o2.getConfig().lastModified() ? -1 : 0));
            } else if (o1 == null) {
                result = -1;
            } else if (o2 == null) {
                result = 1;
            }
            return result;
        }
    }

    public static class Identifier
    implements Comparable<Identifier> {
        private static final String DELIM = ". _-";
        private int major;
        private int minor;
        private int service;

        public Identifier(int major, int minor, int service) {
            this.major = major;
            this.minor = minor;
            this.service = service;
        }

        Identifier(String versionString) {
            StringTokenizer tokenizer = new StringTokenizer(versionString, DELIM);
            if (tokenizer.hasMoreTokens()) {
                this.major = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                this.minor = Integer.parseInt(tokenizer.nextToken());
            }
            try {
                if (tokenizer.hasMoreTokens()) {
                    this.service = Integer.parseInt(tokenizer.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        boolean isGreaterEqualTo(Identifier minimum) {
            if (this.major < minimum.major) {
                return false;
            }
            if (this.major > minimum.major) {
                return true;
            }
            if (this.minor < minimum.minor) {
                return false;
            }
            if (this.minor > minimum.minor) {
                return true;
            }
            return this.service >= minimum.service;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            void o;
            if (!(other instanceof Identifier)) {
                return false;
            }
            Identifier identifier = (Identifier)other;
            return this.major == o.major && this.minor == o.minor && this.service == o.service;
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.service);
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.service;
        }

        @Override
        public int compareTo(Identifier o) {
            if (o != null) {
                if (this.major < o.major) {
                    return -1;
                }
                if (this.major > o.major) {
                    return 1;
                }
                if (this.minor < o.minor) {
                    return -1;
                }
                if (this.minor > o.minor) {
                    return 1;
                }
                if (this.service < o.service) {
                    return -1;
                }
                if (this.service > o.service) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
    }
}

