/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.SessionConfig;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.project.facet.IWebCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.resources.WebContentChangeListener;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCorePlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CreateDeploymentDescriptorCommand
extends AbstractDataModelOperation {
    private String projectName;
    private WebContentChangeListener webContentChangeListener;

    public CreateDeploymentDescriptorCommand(String projectName) {
        this.projectName = projectName;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IFile webXmlFile;
        this.webContentChangeListener = new WebContentChangeListener(this.projectName);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.webContentChangeListener, 1);
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        Path webXmlFilePath = new Path("WEB-INF/web.xml");
        IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)project);
        if (virtualComponent.getRootFolder() != null && virtualComponent.getRootFolder().getUnderlyingFolder() != null && !(webXmlFile = virtualComponent.getRootFolder().getUnderlyingFolder().getFile((IPath)webXmlFilePath)).exists()) {
            IDataModel dataModel = DataModelFactory.createDataModel(IWebCreateDeploymentFilesDataModelProperties.class);
            dataModel.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)project);
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        provider.modify(new Runnable(){

            @Override
            public void run() {
                Object modelProvider = provider.getModelObject();
                boolean useSpringAppContext = CXFCorePlugin.getDefault().getJava2WSContext().isUseSpringApplicationContext();
                if (modelProvider instanceof WebApp) {
                    WebApp javaeeWebApp = (WebApp)modelProvider;
                    CreateDeploymentDescriptorCommand.this.addCXFJSTWEB25Servlet(project, javaeeWebApp);
                    if (useSpringAppContext) {
                        CreateDeploymentDescriptorCommand.this.addSpringApplicationContextWeb25(project, javaeeWebApp);
                    }
                }
            }
        }, null);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        ArrayList changedResources = new ArrayList();
        changedResources.addAll(this.webContentChangeListener.getChangedResources());
        if (changedResources.size() > 0) {
            for (IResource resource : changedResources) {
                try {
                    resource.delete(true, monitor);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                    CXFCreationCorePlugin.log(status);
                }
            }
        }
        return status;
    }

    private void addSpringApplicationContextWeb25(IProject webProject, WebApp webapp) {
        List contextParams = webapp.getContextParams();
        int i = 0;
        while (i < contextParams.size()) {
            ParamValue contextParam = (ParamValue)contextParams.get(i);
            if (contextParam.getParamName().equals("contextConfigLocation")) {
                return;
            }
            ++i;
        }
        List listeners = webapp.getListeners();
        int i2 = 0;
        while (i2 < listeners.size()) {
            Listener contextLoaderListener = (Listener)listeners.get(i2);
            if (contextLoaderListener.getListenerClass().equals("org.springframework.web.context.ContextLoaderListener")) {
                return;
            }
            ++i2;
        }
        JavaeeFactory javaeeFactory = JavaeeFactory.eINSTANCE;
        ParamValue configLocationParam = javaeeFactory.createParamValue();
        configLocationParam.setParamName("contextConfigLocation");
        configLocationParam.setParamValue("WEB-INF/cxf-beans.xml");
        webapp.getContextParams().add(configLocationParam);
        Listener contextLoaderListener = javaeeFactory.createListener();
        contextLoaderListener.setListenerClass("org.springframework.web.context.ContextLoaderListener");
        webapp.getListeners().add(contextLoaderListener);
    }

    private void addCXFJSTWEB25Servlet(IProject webProject, WebApp webapp) {
        List servlets = webapp.getServlets();
        int i = 0;
        while (i < servlets.size()) {
            Servlet servlet = (Servlet)servlets.get(i);
            if (servlet.getServletName().equals("cxf")) {
                return;
            }
            ++i;
        }
        WebFactory factory = WebFactory.eINSTANCE;
        Servlet cxfServlet = factory.createServlet();
        cxfServlet.setServletName("cxf");
        DisplayName cxfServletDisplayName = JavaeeFactory.eINSTANCE.createDisplayName();
        cxfServletDisplayName.setValue("cxf");
        cxfServlet.getDisplayNames().add(cxfServletDisplayName);
        Description cxfServletDescription = JavaeeFactory.eINSTANCE.createDescription();
        cxfServletDescription.setValue("Apache CXF Endpoint");
        cxfServlet.getDescriptions().add(cxfServletDescription);
        cxfServlet.setServletClass("org.apache.cxf.transport.servlet.CXFServlet");
        cxfServlet.setLoadOnStartup((Object)1);
        webapp.getServlets().add(cxfServlet);
        ServletMapping cxfServletMapping = factory.createServletMapping();
        cxfServletMapping.setServletName("cxf");
        UrlPatternType url = JavaeeFactory.eINSTANCE.createUrlPatternType();
        url.setValue("/services/*");
        cxfServletMapping.getUrlPatterns().add(url);
        webapp.getServletMappings().add(cxfServletMapping);
        SessionConfig sessionConfig = factory.createSessionConfig();
        sessionConfig.setSessionTimeout(new BigInteger("60"));
        webapp.getSessionConfigs().add(sessionConfig);
    }
}

