/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.impl;

import java.util.function.Predicate;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.reviews.Authorable;
import org.eclipse.emf.cdo.lm.reviews.ModelReference;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.Topic;
import org.eclipse.emf.cdo.lm.reviews.TopicContainer;
import org.eclipse.emf.cdo.lm.reviews.TopicStatus;
import org.eclipse.emf.cdo.lm.reviews.impl.TopicContainerImpl;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.net4j.util.StringUtil;

public class TopicImpl
extends TopicContainerImpl
implements Topic {
    protected static final int ID_EDEFAULT = 0;
    protected static final String TEXT_EDEFAULT = null;
    protected static final String AUTHOR_EDEFAULT = null;
    protected static final long CREATION_TIME_EDEFAULT = 0L;
    protected static final long EDIT_TIME_EDEFAULT = 0L;
    protected static final boolean HEADING_EDEFAULT = false;
    protected static final ModelReference MODEL_REFERENCE_EDEFAULT = null;
    protected static final TopicStatus STATUS_EDEFAULT = TopicStatus.NONE;
    protected static final String OUTLINE_NUMBER_EDEFAULT = null;
    protected static final int PARENT_INDEX_EDEFAULT = 0;

    protected TopicImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.TOPIC;
    }

    @Override
    public int getId() {
        return (Integer)this.eDynamicGet(7, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__ID, true, true);
    }

    @Override
    public void setId(int newId) {
        this.eDynamicSet(7, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__ID, newId);
    }

    @Override
    public String getText() {
        return (String)this.eDynamicGet(8, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__TEXT, true, true);
    }

    @Override
    public void setText(String newText) {
        this.eDynamicSet(8, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__TEXT, newText);
    }

    @Override
    public boolean isHeading() {
        return (Boolean)this.eDynamicGet(12, (EStructuralFeature)ReviewsPackage.Literals.TOPIC__HEADING, true, true);
    }

    @Override
    public void setHeading(boolean newHeading) {
        this.eDynamicSet(12, (EStructuralFeature)ReviewsPackage.Literals.TOPIC__HEADING, newHeading);
    }

    @Override
    public ModelReference getModelReference() {
        return (ModelReference)this.eDynamicGet(13, (EStructuralFeature)ReviewsPackage.Literals.TOPIC__MODEL_REFERENCE, true, true);
    }

    @Override
    public void setModelReference(ModelReference newModelReference) {
        this.eDynamicSet(13, (EStructuralFeature)ReviewsPackage.Literals.TOPIC__MODEL_REFERENCE, newModelReference);
    }

    @Override
    public TopicStatus getStatus() {
        return (TopicStatus)((Object)this.eDynamicGet(14, (EStructuralFeature)ReviewsPackage.Literals.TOPIC__STATUS, true, true));
    }

    @Override
    public void setStatus(TopicStatus newStatus) {
        this.eDynamicSet(14, (EStructuralFeature)ReviewsPackage.Literals.TOPIC__STATUS, (Object)newStatus);
    }

    @Override
    public String getAuthor() {
        return (String)this.eDynamicGet(9, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__AUTHOR, true, true);
    }

    @Override
    public void setAuthor(String newAuthor) {
        this.eDynamicSet(9, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__AUTHOR, newAuthor);
    }

    @Override
    public long getCreationTime() {
        return (Long)this.eDynamicGet(10, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__CREATION_TIME, true, true);
    }

    @Override
    public void setCreationTime(long newCreationTime) {
        this.eDynamicSet(10, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__CREATION_TIME, newCreationTime);
    }

    @Override
    public long getEditTime() {
        return (Long)this.eDynamicGet(11, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__EDIT_TIME, true, true);
    }

    @Override
    public void setEditTime(long newEditTime) {
        this.eDynamicSet(11, (EStructuralFeature)ReviewsPackage.Literals.AUTHORABLE__EDIT_TIME, newEditTime);
    }

    @Override
    public TopicContainer getContainer() {
        return (TopicContainer)this.eDynamicGet(15, (EStructuralFeature)ReviewsPackage.Literals.TOPIC__CONTAINER, true, true);
    }

    public NotificationChain basicSetContainer(TopicContainer newContainer, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newContainer, 15, msgs);
        return msgs;
    }

    @Override
    public void setContainer(TopicContainer newContainer) {
        this.eDynamicSet(15, (EStructuralFeature)ReviewsPackage.Literals.TOPIC__CONTAINER, newContainer);
    }

    @Override
    public Topic getParentHeading() {
        TopicContainer container = this.getContainer();
        while (container != null) {
            if (!(container instanceof Topic)) break;
            Topic topic = (Topic)container;
            if (topic.isHeading()) {
                return topic;
            }
            container = topic.getContainer();
        }
        return null;
    }

    @Override
    public Topic getPreviousHeading() {
        TopicContainer container = this.getContainer();
        if (container == null) {
            return null;
        }
        EList<Topic> topics = container.getTopics();
        int index = topics.indexOf((Object)this);
        if (index == -1) {
            return null;
        }
        int i = index - 1;
        while (i >= 0) {
            Topic topic = (Topic)topics.get(i);
            if (topic.isHeading()) {
                return topic;
            }
            --i;
        }
        return null;
    }

    @Override
    public Topic getNextHeading() {
        TopicContainer container = this.getContainer();
        if (container == null) {
            return null;
        }
        EList<Topic> topics = container.getTopics();
        int index = topics.indexOf((Object)this);
        if (index == -1) {
            return null;
        }
        int i = index + 1;
        int size = topics.size();
        while (i < size) {
            Topic topic = (Topic)topics.get(i);
            if (topic.isHeading()) {
                return topic;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getOutlineNumber() {
        StringBuilder builder = new StringBuilder();
        TopicImpl.formatOutlineNumber(builder, this);
        return builder.toString();
    }

    @Override
    public int getParentIndex() {
        TopicContainer container = this.getContainer();
        if (container == null) {
            return 1;
        }
        EList<Topic> topics = container.getTopics();
        int index = topics.indexOf((Object)this);
        if (index == -1) {
            return 1;
        }
        int count = 1;
        int i = 0;
        while (i < index) {
            Topic topic = (Topic)topics.get(i);
            if (topic.isHeading()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 15: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetContainer((TopicContainer)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 15: {
                return this.basicSetContainer(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 15: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 2, TopicContainer.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getId();
            }
            case 8: {
                return this.getText();
            }
            case 9: {
                return this.getAuthor();
            }
            case 10: {
                return this.getCreationTime();
            }
            case 11: {
                return this.getEditTime();
            }
            case 12: {
                return this.isHeading();
            }
            case 13: {
                return this.getModelReference();
            }
            case 14: {
                return this.getStatus();
            }
            case 15: {
                return this.getContainer();
            }
            case 16: {
                return this.getParentHeading();
            }
            case 17: {
                return this.getPreviousHeading();
            }
            case 18: {
                return this.getNextHeading();
            }
            case 19: {
                return this.getOutlineNumber();
            }
            case 20: {
                return this.getParentIndex();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setId((Integer)newValue);
                return;
            }
            case 8: {
                this.setText((String)newValue);
                return;
            }
            case 9: {
                this.setAuthor((String)newValue);
                return;
            }
            case 10: {
                this.setCreationTime((Long)newValue);
                return;
            }
            case 11: {
                this.setEditTime((Long)newValue);
                return;
            }
            case 12: {
                this.setHeading((Boolean)newValue);
                return;
            }
            case 13: {
                this.setModelReference((ModelReference)newValue);
                return;
            }
            case 14: {
                this.setStatus((TopicStatus)((Object)newValue));
                return;
            }
            case 15: {
                this.setContainer((TopicContainer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setId(0);
                return;
            }
            case 8: {
                this.setText(TEXT_EDEFAULT);
                return;
            }
            case 9: {
                this.setAuthor(AUTHOR_EDEFAULT);
                return;
            }
            case 10: {
                this.setCreationTime(0L);
                return;
            }
            case 11: {
                this.setEditTime(0L);
                return;
            }
            case 12: {
                this.setHeading(false);
                return;
            }
            case 13: {
                this.setModelReference(MODEL_REFERENCE_EDEFAULT);
                return;
            }
            case 14: {
                this.setStatus(STATUS_EDEFAULT);
                return;
            }
            case 15: {
                this.setContainer(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return this.getId() != 0;
            }
            case 8: {
                return TEXT_EDEFAULT == null ? this.getText() != null : !TEXT_EDEFAULT.equals(this.getText());
            }
            case 9: {
                return AUTHOR_EDEFAULT == null ? this.getAuthor() != null : !AUTHOR_EDEFAULT.equals(this.getAuthor());
            }
            case 10: {
                return this.getCreationTime() != 0L;
            }
            case 11: {
                return this.getEditTime() != 0L;
            }
            case 12: {
                return this.isHeading();
            }
            case 13: {
                return MODEL_REFERENCE_EDEFAULT == null ? this.getModelReference() != null : !MODEL_REFERENCE_EDEFAULT.equals(this.getModelReference());
            }
            case 14: {
                return this.getStatus() != STATUS_EDEFAULT;
            }
            case 15: {
                return this.getContainer() != null;
            }
            case 16: {
                return this.getParentHeading() != null;
            }
            case 17: {
                return this.getPreviousHeading() != null;
            }
            case 18: {
                return this.getNextHeading() != null;
            }
            case 19: {
                return OUTLINE_NUMBER_EDEFAULT == null ? this.getOutlineNumber() != null : !OUTLINE_NUMBER_EDEFAULT.equals(this.getOutlineNumber());
            }
            case 20: {
                return this.getParentIndex() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == Authorable.class) {
            switch (derivedFeatureID) {
                case 7: {
                    return 1;
                }
                case 8: {
                    return 2;
                }
                case 9: {
                    return 3;
                }
                case 10: {
                    return 4;
                }
                case 11: {
                    return 5;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == Authorable.class) {
            switch (baseFeatureID) {
                case 1: {
                    return 7;
                }
                case 2: {
                    return 8;
                }
                case 3: {
                    return 9;
                }
                case 4: {
                    return 10;
                }
                case 5: {
                    return 11;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public System getSystem() {
        TopicContainer container = this.getContainer();
        return container == null ? null : container.getSystem();
    }

    @Override
    public Review getReview() {
        TopicContainer container = this.getContainer();
        return container == null ? null : container.getReview();
    }

    @Override
    public boolean forEachTopic(Predicate<Topic> consumer) {
        if (!consumer.test(this)) {
            return false;
        }
        return super.forEachTopic(consumer);
    }

    private static void formatOutlineNumber(StringBuilder builder, Topic heading) {
        Topic parentHeading = heading.getParentHeading();
        if (parentHeading != null) {
            TopicImpl.formatOutlineNumber(builder, parentHeading);
        }
        StringUtil.appendSeparator((StringBuilder)builder, (char)'.');
        builder.append(heading.getParentIndex());
    }
}

