/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.util.io.IORuntimeException;

public class OpenViewIndication
extends CDOServerReadIndication {
    private int viewID;
    private boolean readOnly;
    private CDOBranchPoint branchPoint;
    private String durableLockingID;
    private boolean respondLockGrades;

    public OpenViewIndication(CDOServerProtocol protocol) {
        super(protocol, (short)3);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.viewID = in.readXInt();
        this.readOnly = in.readBoolean();
        if (in.readBoolean()) {
            this.branchPoint = in.readCDOBranchPoint();
        } else {
            this.durableLockingID = in.readString();
            this.respondLockGrades = in.readBoolean();
        }
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalSession session = this.getSession();
        if (this.branchPoint != null) {
            Object newView2 = this.readOnly ? session.openView(this.viewID, this.branchPoint) : session.openTransaction(this.viewID, this.branchPoint);
            OpenViewIndication.respondNewView(out, (IView)newView2, null);
        } else {
            InternalLockManager lockManager = this.getRepository().getLockingManager();
            String message = null;
            BiConsumer<CDOID, IDurableLockingManager.LockGrade> lockConsumer = this.respondLockGrades ? (id, lockGrade) -> {
                try {
                    out.writeCDOID(id);
                    out.writeEnum((Enum)lockGrade);
                }
                catch (IOException ex) {
                    throw new IORuntimeException((Throwable)ex);
                }
            } : null;
            try {
                try {
                    lockManager.openView((ISession)session, this.viewID, this.readOnly, this.durableLockingID, newView -> {
                        try {
                            OpenViewIndication.respondNewView(out, newView, null);
                        }
                        catch (IOException ex) {
                            throw new IORuntimeException((Throwable)ex);
                        }
                    }, lockConsumer);
                }
                catch (IORuntimeException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw ex;
                }
                if (this.respondLockGrades) {
                    out.writeCDOID(null);
                }
                return;
            }
            catch (IDurableLockingManager.LockAreaNotFoundException ex) {
            }
            catch (IllegalStateException ex) {
                message = ex.getMessage();
            }
            OpenViewIndication.respondNewView(out, null, message);
        }
    }

    private static void respondNewView(CDODataOutput out, IView newView, String message) throws IOException {
        if (newView != null) {
            out.writeBoolean(true);
            out.writeCDOBranchPoint((CDOBranchPoint)newView);
        } else {
            out.writeBoolean(false);
            out.writeString(message);
        }
    }
}

