/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenRepresentationsAction;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenEditorDoubleClickListener
implements IDoubleClickListener {
    private Session session;

    public OpenEditorDoubleClickListener(Session theSession) {
        this.session = theSession;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event != null && event.getSelection() instanceof IStructuredSelection) {
            List selection = ((IStructuredSelection)event.getSelection()).toList();
            Set<DRepresentationDescriptor> repDescriptorToOpen = this.getRepresentationDescriptorsToOpen(selection);
            if (!repDescriptorToOpen.isEmpty()) {
                this.activateViewpoints(repDescriptorToOpen);
                this.openRepresentations(repDescriptorToOpen);
            } else if (!selection.isEmpty()) {
                this.openSessionEditor(selection);
            }
        }
    }

    protected void openRepresentations(Set<DRepresentationDescriptor> repDescriptorToOpen) {
        new OpenRepresentationsAction(repDescriptorToOpen).run();
    }

    private void activateViewpoints(Set<DRepresentationDescriptor> repDescriptorToOpen) {
        if (this.session != null) {
            HashSet<Viewpoint> viewpointsToActivate = new HashSet<Viewpoint>();
            repDescriptorToOpen.forEach(repDesc -> {
                Viewpoint parentViewpoint = ViewpointHelper.getViewpointInVSM(this.session, new RepresentationDescriptionQuery(repDesc.getDescription()).getParentViewpoint());
                if (parentViewpoint != null) {
                    boolean activateViewpoint;
                    boolean bl = activateViewpoint = !ViewpointHelper.isViewpointEnabledInSession(this.session, parentViewpoint);
                    if (activateViewpoint) {
                        viewpointsToActivate.add(parentViewpoint);
                    }
                }
            });
            if (!viewpointsToActivate.isEmpty()) {
                ViewpointHelper.handleViewpointActivation(this.session, viewpointsToActivate, true, false);
            }
        }
    }

    protected void openSessionEditor(List<?> selectionList) {
        Object element = selectionList.get(0);
        if (element instanceof IFile && new FileQuery((IFile)element).isSessionResourceFile()) {
            IEditorDescriptor defaultEditor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(((IFile)element).getName());
            FileEditorInput fileEditorInput = new FileEditorInput((IFile)element);
            if (fileEditorInput != null) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)fileEditorInput, defaultEditor.getId());
                }
                catch (PartInitException e) {
                    SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
                }
            }
        }
    }

    protected Set<DRepresentationDescriptor> getRepresentationDescriptorsToOpen(List<?> selection) {
        LinkedHashSet<DRepresentationDescriptor> repDescriptors = new LinkedHashSet<DRepresentationDescriptor>();
        for (Object obj : selection) {
            if (obj instanceof DRepresentationDescriptor) {
                repDescriptors.add((DRepresentationDescriptor)obj);
                continue;
            }
            DRepresentationDescriptor adapted = this.adaptToDRepresentationDescriptor(obj);
            if (adapted == null) continue;
            repDescriptors.add(adapted);
        }
        return repDescriptors;
    }

    private DRepresentationDescriptor adaptToDRepresentationDescriptor(Object input) {
        Object adapter;
        if (input instanceof IAdaptable && (adapter = ((IAdaptable)input).getAdapter(EObject.class)) instanceof DRepresentationDescriptor) {
            return (DRepresentationDescriptor)adapter;
        }
        return null;
    }
}

