/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.text;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.text.FlowUtilitiesEx;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextUtilitiesEx;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class TextFlowEx
extends TextFlow {
    private static int FLAG_UNDERLINED = Figure.MAX_FLAG << 1;
    private static int FLAG_STRIKEDTHROUGH;
    protected static final int MAX_FLAG;
    private String truncationString = "...";
    private FlowUtilitiesEx flowUtilities;
    private TextUtilitiesEx textUtilities;
    private int nDPtoLP_1 = -1;

    static {
        MAX_FLAG = FLAG_STRIKEDTHROUGH = Figure.MAX_FLAG << 2;
    }

    public TextFlowEx() {
    }

    public TextFlowEx(String text) {
        super(text);
    }

    protected String getTruncationString() {
        return this.truncationString;
    }

    public void setTruncationString(String truncationString) {
        this.truncationString = truncationString;
    }

    public boolean isTextStrikedThrough() {
        return (this.flags & FLAG_STRIKEDTHROUGH) != 0;
    }

    public void setTextStrikeThrough(boolean strikeThrough) {
        if (this.isTextStrikedThrough() == strikeThrough) {
            return;
        }
        this.setFlag(FLAG_STRIKEDTHROUGH, strikeThrough);
        this.repaint();
    }

    public boolean isTextUnderlined() {
        return (this.flags & FLAG_UNDERLINED) != 0;
    }

    public void setTextUnderline(boolean underline) {
        if (this.isTextUnderlined() == underline) {
            return;
        }
        this.setFlag(FLAG_UNDERLINED, underline);
        this.repaint();
    }

    protected void paintFigure(Graphics g) {
        g.getClip(Rectangle.SINGLETON);
        int yStart = Rectangle.SINGLETON.y;
        int yEnd = Rectangle.SINGLETON.bottom();
        Rectangle maxBounds = this.getVisibleBounds();
        int i = 0;
        while (i < this.getFragments().size()) {
            TextFragmentBox frag = (TextFragmentBox)this.getFragments().get(i);
            if (frag.offset != -1 && yStart <= this.getVisibleBottom(frag) + 1) {
                if (yEnd < this.getVisibleTop(frag)) break;
                Object draw = this.getBidiSubstring(frag, i);
                boolean truncate = frag.isTruncated();
                if (i + 1 < this.getFragments().size() && maxBounds.bottom() < this.getVisibleBottom((TextFragmentBox)this.getFragments().get(i + 1))) {
                    draw = this.truncateText((String)draw);
                    truncate = true;
                    i = this.getFragments().size();
                }
                if (truncate) {
                    draw = (String)draw + this.getTruncationString();
                }
                if (!this.isEnabled()) {
                    Color cachedfgColor = g.getForegroundColor();
                    g.setForegroundColor(ColorConstants.buttonLightest);
                    this.paintText(g, (String)draw, frag.getX() + this.getDPtoLP1(), frag.getBaseline() - frag.getAscent() + this.getDPtoLP1(), frag.getBidiLevel());
                    g.setForegroundColor(ColorConstants.buttonDarker);
                    this.paintText(g, (String)draw, frag.getX(), frag.getBaseline() - frag.getAscent(), frag.getBidiLevel());
                    g.setForegroundColor(cachedfgColor);
                } else {
                    this.paintText(g, (String)draw, frag.getX(), frag.getBaseline() - frag.getAscent(), frag.getBidiLevel());
                }
                this.drawTextAdornments(g, frag);
            }
            ++i;
        }
    }

    private int getDPtoLP1() {
        if (this.nDPtoLP_1 == -1) {
            this.nDPtoLP_1 = MapModeUtil.getMapMode((IFigure)this).DPtoLP(1);
        }
        return this.nDPtoLP_1;
    }

    private void drawTextAdornments(Graphics g, TextFragmentBox fragment) {
        int baseline = fragment.getBaseline();
        if (this.isTextUnderlined()) {
            g.drawLine(fragment.getX(), baseline += this.getDPtoLP1(), fragment.getWidth() + fragment.getX(), baseline);
        }
        if (this.isTextStrikedThrough()) {
            int y = fragment.getBaseline() - fragment.getAscent() + (fragment.getAscent() + fragment.getDescent() + this.getDPtoLP1()) / 2;
            g.drawLine(fragment.getX(), y, fragment.getWidth() + fragment.getX(), y);
        }
    }

    private int getVisibleTop(TextFragmentBox fragment) {
        return fragment.getBaseline() - fragment.getAscent();
    }

    private int getVisibleBottom(TextFragmentBox fragment) {
        return fragment.getBaseline() + fragment.getDescent();
    }

    protected String truncateText(String text) {
        int maxWidth = this.getVisibleBounds().width;
        Font currentFont = this.getFont();
        int ellipsisWidth = this.getTextUtilities().getTextExtents((String)this.getTruncationString(), (Font)currentFont).width;
        if (maxWidth < ellipsisWidth) {
            maxWidth = ellipsisWidth;
        }
        int subStringLength = this.getTextUtilities().getLargestSubstringConfinedTo(text, currentFont, maxWidth - ellipsisWidth);
        return new String(text.substring(0, subStringLength));
    }

    public FlowUtilitiesEx getFlowUtilities() {
        if (this.flowUtilities == null) {
            this.flowUtilities = new FlowUtilitiesEx(MapModeUtil.getMapMode((IFigure)this));
        }
        return this.flowUtilities;
    }

    public TextUtilitiesEx getTextUtilities() {
        if (this.textUtilities == null) {
            this.textUtilities = new TextUtilitiesEx(MapModeUtil.getMapMode((IFigure)this));
        }
        return this.textUtilities;
    }

    private Rectangle getVisibleBounds() {
        return this.getParent().getClientArea();
    }
}

