/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.DropDownMenuAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;

public class PushSettings {
    private static final String PER_REPO_SETTINGS_PREFIX = "repository_push_settings_";
    private static final String SEPARATOR = ";";
    private static final String NONE = "-";
    private final IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
    private IPropertyChangeListener listener = event -> {
        if (this.key != null && this.key.equals(event.getProperty())) {
            this.runInUiThread(() -> this.load(this.key));
        }
    };
    private boolean forceState;
    private boolean dialogState;
    private String key;
    private String[] values;
    private boolean enabled;
    private boolean visible;
    private ToolBar toolbar;
    private PushSettingsAction action;

    public PushSettings() {
        this.preferences.addPropertyChangeListener(this.listener);
    }

    public PushSettings(Repository repository) {
        this();
        this.load(repository);
    }

    public void load(Repository repository) {
        this.key = repository == null ? null : PER_REPO_SETTINGS_PREFIX + repository.getDirectory().getAbsolutePath();
        this.load(this.key);
    }

    private void load(String prefKey) {
        if (prefKey == null) {
            this.forceState = false;
            this.dialogState = false;
            this.setEnabled(false);
        } else {
            String prefs = this.preferences.getString(prefKey);
            this.values = StringUtils.isEmptyOrNull((String)prefs) ? null : prefs.split(SEPARATOR);
            if (this.values == null || this.values.length < 2) {
                this.values = new String[]{Boolean.FALSE.toString(), NONE};
            }
            this.forceState = Boolean.parseBoolean(this.values[0]);
            this.dialogState = StringUtils.isEmptyOrNull((String)this.values[1]) || NONE.equals(this.values[1]) ? this.preferences.getBoolean("always_show_push_wizard") : Boolean.parseBoolean(this.values[1]);
            this.setEnabled(true);
        }
        this.updateImage();
    }

    private void runInUiThread(Runnable r) {
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            Display.getDefault().asyncExec(r);
        }
    }

    private void save() {
        if (this.key != null) {
            this.preferences.setValue(this.key, String.join((CharSequence)SEPARATOR, this.values));
        }
    }

    public void dispose() {
        if (this.listener != null) {
            this.preferences.removePropertyChangeListener(this.listener);
            this.listener = null;
        }
    }

    public boolean isForce() {
        return this.forceState;
    }

    public boolean alwaysShowDialog() {
        return this.dialogState;
    }

    public Control createControl(Composite parent) {
        if (this.toolbar == null) {
            ToolBarManager settingsManager = new ToolBarManager(0x800100);
            this.action = new PushSettingsAction();
            settingsManager.add((IAction)this.action);
            this.action.setEnabled(this.isEnabled());
            this.toolbar = settingsManager.createControl(parent);
            this.toolbar.setEnabled(this.isEnabled());
            this.updateImage();
        }
        return this.toolbar;
    }

    public Control getControl() {
        return this.toolbar;
    }

    private void updateImage() {
        if (this.action != null && this.toolbar != null && !this.toolbar.isDisposed()) {
            this.action.setImageDescriptor(this.isForce() ? UIIcons.SETTINGS_FORCE : UIIcons.SETTINGS);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            this.toolbar.setEnabled(enabled);
        }
        if (this.action != null) {
            this.action.setEnabled(enabled);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            this.toolbar.setVisible(visible);
        }
    }

    private class PushSettingsAction
    extends DropDownMenuAction {
        public PushSettingsAction() {
            super(UIText.PushSettings_Title);
            this.setImageDescriptor(UIIcons.SETTINGS);
        }

        @Override
        protected Collection<IContributionItem> getActions() {
            if (!this.isEnabled()) {
                return Collections.emptyList();
            }
            ArrayList<IContributionItem> items = new ArrayList<IContributionItem>(2);
            Action forceAction = new Action(UIText.PushSettings_Force, 2){

                public void run() {
                    ((PushSettingsAction)PushSettingsAction.this).PushSettings.this.forceState = this.isChecked();
                    ((PushSettingsAction)PushSettingsAction.this).PushSettings.this.values[0] = Boolean.toString(((PushSettingsAction)PushSettingsAction.this).PushSettings.this.forceState);
                    PushSettings.this.save();
                    PushSettings.this.updateImage();
                }
            };
            forceAction.setChecked(PushSettings.this.forceState);
            items.add((IContributionItem)new ActionContributionItem((IAction)forceAction));
            Action showDialogAction = new Action(UIText.PushSettings_DialogAlways, 2){

                public void run() {
                    ((PushSettingsAction)PushSettingsAction.this).PushSettings.this.dialogState = this.isChecked();
                    ((PushSettingsAction)PushSettingsAction.this).PushSettings.this.values[1] = Boolean.toString(((PushSettingsAction)PushSettingsAction.this).PushSettings.this.dialogState);
                    PushSettings.this.save();
                }
            };
            showDialogAction.setChecked(PushSettings.this.dialogState);
            items.add((IContributionItem)new ActionContributionItem((IAction)showDialogAction));
            return items;
        }
    }
}

