/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters;

import java.lang.reflect.Array;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.plexus.Roles;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup, configuration, type, enclosingType, loader, evaluator, null);
    }

    @Deprecated
    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        return this.fromExpression(configuration, evaluator, null);
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type) throws ComponentConfigurationException {
        return this.fromExpression(configuration, evaluator, type, true);
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type, boolean enforceTypeCompatibility) throws ComponentConfigurationException {
        String value = configuration.getValue();
        try {
            Object result = null;
            if (null != value && !value.isEmpty()) {
                result = evaluator instanceof TypeAwareExpressionEvaluator && type != null ? ((TypeAwareExpressionEvaluator)evaluator).evaluate(value, type) : evaluator.evaluate(value);
            }
            if (null == result && configuration.getChildCount() == 0 && null != (value = configuration.getAttribute("default-value")) && !value.isEmpty()) {
                result = evaluator instanceof TypeAwareExpressionEvaluator && type != null ? ((TypeAwareExpressionEvaluator)evaluator).evaluate(value, type) : evaluator.evaluate(value);
            }
            if (enforceTypeCompatibility && type != null) {
                this.failIfNotTypeCompatible(result, type, configuration);
            }
            return result;
        }
        catch (ExpressionEvaluationException e) {
            String reason = String.format("Cannot evaluate expression '%s' for configuration entry '%s'", value, configuration.getName());
            throw new ComponentConfigurationException(configuration, reason, e);
        }
    }

    protected final String fromXML(String name) {
        return Roles.camelizeName(name);
    }

    protected final void failIfNotTypeCompatible(Object value, Class<?> type, PlexusConfiguration configuration) throws ComponentConfigurationException {
        if (null != value && null != type && !type.isInstance(value)) {
            String reason = String.format("Cannot assign configuration entry '%s' with value '%s' of type %s to property of type %s", configuration.getName(), configuration.getValue(), value.getClass().getCanonicalName(), type.getCanonicalName());
            throw new ComponentConfigurationException(configuration, reason);
        }
    }

    protected final Class<?> getClassForImplementationHint(Class<?> type, PlexusConfiguration configuration, ClassLoader loader) throws ComponentConfigurationException {
        String hint = configuration.getAttribute("implementation");
        if (null == hint) {
            return type;
        }
        try {
            int dims = 0;
            while (hint.endsWith("[]")) {
                hint = hint.substring(0, hint.length() - 2);
                ++dims;
            }
            Class<?> implType = loader.loadClass(hint);
            while (dims > 0) {
                implType = Array.newInstance(implType, 0).getClass();
                --dims;
            }
            return implType;
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", (Throwable)e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", (Throwable)e);
        }
    }

    protected final Object instantiateObject(Class<?> type) throws ComponentConfigurationException {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Cannot create instance of " + type, (Throwable)e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("Cannot create instance of " + type, (Throwable)e);
        }
    }
}

