/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.externaltools.internal.launchConfigurations;

import java.io.File;
import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsProgramMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.osgi.util.NLS;

public class ExternalToolsCoreUtil {
    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.externaltools", code, message, exception));
    }

    public static IPath getLocation(ILaunchConfiguration configuration) throws CoreException {
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        if (location == null) {
            ExternalToolsCoreUtil.abort(NLS.bind((String)ExternalToolsProgramMessages.ExternalToolsUtil_Location_not_specified_by__0__1, (Object)configuration.getName()), null, 0);
        } else {
            String expandedLocation = ExternalToolsCoreUtil.getStringVariableManager().performStringSubstitution(location);
            if (expandedLocation == null || expandedLocation.length() == 0) {
                String msg = NLS.bind((String)ExternalToolsProgramMessages.ExternalToolsUtil_invalidLocation__0_, (Object[])new Object[]{configuration.getName()});
                ExternalToolsCoreUtil.abort(msg, null, 0);
            } else {
                File file = new File(expandedLocation);
                if (file.isFile()) {
                    return IPath.fromOSString((String)expandedLocation);
                }
                String msg = NLS.bind((String)ExternalToolsProgramMessages.ExternalToolsUtil_invalidLocation__0_, (Object[])new Object[]{configuration.getName()});
                ExternalToolsCoreUtil.abort(msg, null, 0);
            }
        }
        return null;
    }

    public static boolean getCaptureOutput(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.debug.core.capture_output", true);
    }

    public static IPath getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String expandedLocation;
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = ExternalToolsCoreUtil.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            File path = new File(expandedLocation);
            if (path.isDirectory()) {
                return IPath.fromOSString((String)expandedLocation);
            }
            String msg = NLS.bind((String)ExternalToolsProgramMessages.ExternalToolsUtil_invalidDirectory__0_, (Object[])new Object[]{expandedLocation, configuration.getName()});
            ExternalToolsCoreUtil.abort(msg, null, 0);
        }
        return null;
    }

    public static String[] getArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        if (args != null) {
            String expanded = ExternalToolsCoreUtil.getStringVariableManager().performStringSubstitution(args);
            return ExternalToolsCoreUtil.parseStringIntoList(expanded);
        }
        return null;
    }

    private static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    public static boolean isBuilderEnabled(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", true);
    }

    public static IResource[] getResourcesForBuildScope(ILaunchConfiguration configuration) throws CoreException {
        String scope = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", null);
        if (scope == null) {
            return null;
        }
        return RefreshUtil.toResources((String)scope);
    }

    public static String[] parseStringIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        String[] res = DebugPlugin.parseArguments((String)arguments);
        return res;
    }

    public static IProject[] getBuildProjects(ILaunchConfiguration configuration, String buildScopeId) {
        String scope = null;
        String id = buildScopeId;
        if (id == null) {
            id = "org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE";
        }
        try {
            scope = configuration.getAttribute(id, null);
        }
        catch (CoreException e) {
            return null;
        }
        if (scope == null) {
            return null;
        }
        if (scope.startsWith("${projects:")) {
            String pathString = scope.substring(11, scope.length() - 1);
            if (pathString.length() > 0) {
                String[] names = pathString.split(",");
                IProject[] projects = new IProject[names.length];
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int i = 0;
                while (i < names.length) {
                    projects[i] = root.getProject(names[i]);
                    ++i;
                }
                return projects;
            }
        } else if (scope.equals("${project}")) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                String pathString = manager.performStringSubstitution("${selected_resource_path}");
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(IPath.fromOSString((String)pathString));
                if (res != null && res.getProject() != null) {
                    return new IProject[]{res.getProject()};
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return new IProject[0];
    }

    public static boolean isIncludeReferencedProjects(ILaunchConfiguration configuration, String includeReferencedProjectsId) throws CoreException {
        String id = includeReferencedProjectsId;
        if (id == null) {
            id = "org.eclipse.ui.externaltools.ATTR_INCLUDE_REFERENCED_PROJECTS";
        }
        return configuration.getAttribute(id, true);
    }

    public static boolean isAsynchronousBuild(ILaunchConfiguration configuration) {
        boolean launchInBackground = false;
        try {
            launchInBackground = configuration.getAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        }
        catch (CoreException ce) {
            ILog.of(ExternalToolsCoreUtil.class).log(Status.error((String)"Error logged from Ant UI: ", (Throwable)ce));
        }
        return launchInBackground;
    }
}

