/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

@Singleton
public class FeatureCallAsTypeLiteralHelper {
    public boolean isPotentialTypeLiteral(XExpression featureCall, IResolvedTypes resolvedTypes) {
        if (featureCall instanceof XMemberFeatureCall) {
            return this.isPotentialTypeLiteralImpl(featureCall, resolvedTypes, ((XMemberFeatureCall)featureCall).isExplicitStatic());
        }
        return this.isPotentialTypeLiteralImpl(featureCall, resolvedTypes, false);
    }

    protected boolean isPotentialTypeLiteralImpl(XExpression featureCall, IResolvedTypes resolvedTypes, boolean staticNotation) {
        if (featureCall instanceof XMemberFeatureCall) {
            XMemberFeatureCall casted = (XMemberFeatureCall)featureCall;
            if (casted.isExplicitOperationCallOrBuilderSyntax() || casted.isNullSafe()) {
                return false;
            }
            XExpression target = casted.getMemberCallTarget();
            if (casted.isExplicitStatic() != staticNotation) {
                return false;
            }
            return this.isPotentialTypeLiteralImpl(target, resolvedTypes, staticNotation);
        }
        if (featureCall instanceof XFeatureCall) {
            XFeatureCall casted = (XFeatureCall)featureCall;
            if (casted.isExplicitOperationCallOrBuilderSyntax()) {
                return false;
            }
            if (resolvedTypes == null) {
                return true;
            }
            LightweightTypeReference knownType = resolvedTypes.getActualType(casted);
            if (knownType == null || knownType.isUnknown()) {
                return true;
            }
        }
        return false;
    }

    public List<String> getTypeNameSegmentsFromConcreteSyntax(XMemberFeatureCall featureCall) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET);
        List<String> prefix = this.getTypeNameSegmentsFromConcreteSyntax(nodes, featureCall.isExplicitStatic());
        return prefix;
    }

    protected List<String> getTypeNameSegmentsFromConcreteSyntax(List<INode> nodes, boolean staticNotation) {
        ArrayList result = null;
        for (INode node : nodes) {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                String text = leaf.getText();
                if (text.equals("(") || text.equals(")")) {
                    return null;
                }
                if (text.equals(".") && staticNotation) {
                    return null;
                }
                if (text.equals("::") && !staticNotation) {
                    return null;
                }
                if (text.equals(".") || text.equals("::")) continue;
                if (result == null) {
                    result = Lists.newArrayListWithCapacity((int)4);
                }
                if (text.charAt(0) == '^') {
                    result.add(text.substring(1));
                    continue;
                }
                result.add(text);
            }
        }
        return result;
    }

    public XAbstractFeatureCall getRootTypeLiteral(XAbstractFeatureCall featureCall) {
        if (featureCall.isTypeLiteral()) {
            return featureCall;
        }
        if (featureCall.isPackageFragment()) {
            return this.getRootTypeLiteral((XAbstractFeatureCall)featureCall.eContainer());
        }
        if ((featureCall.getFeature() == null || featureCall.getFeature().eIsProxy()) && (featureCall instanceof XFeatureCall || featureCall instanceof XMemberFeatureCall)) {
            if (!this.isPotentialTypeLiteral(featureCall, null)) {
                return null;
            }
            if (featureCall instanceof XMemberFeatureCall) {
                return this.doGetRootTypeLiteral((XMemberFeatureCall)featureCall);
            }
            if (featureCall instanceof XFeatureCall && featureCall.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET) {
                return this.doGetRootTypeLiteral((XMemberFeatureCall)featureCall.eContainer());
            }
        }
        return null;
    }

    protected XAbstractFeatureCall doGetRootTypeLiteral(XMemberFeatureCall featureCall) {
        boolean staticNotation = featureCall.isExplicitStatic();
        XMemberFeatureCall current = featureCall;
        while (current.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET) {
            XMemberFeatureCall container = (XMemberFeatureCall)current.eContainer();
            if (container.isExplicitStatic()) {
                if (!staticNotation) {
                    return current;
                }
                current = container;
                continue;
            }
            if (staticNotation) {
                return (XAbstractFeatureCall)current.getMemberCallTarget();
            }
            current = container;
        }
        if (current != featureCall && staticNotation) {
            return (XAbstractFeatureCall)current.getMemberCallTarget();
        }
        return null;
    }

    public boolean isDefiniteTypeLiteral(XAbstractFeatureCall featureCall) {
        if (featureCall.isExplicitOperationCallOrBuilderSyntax()) {
            return false;
        }
        if (!featureCall.getTypeArguments().isEmpty()) {
            return false;
        }
        if (featureCall.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET) {
            XMemberFeatureCall container = (XMemberFeatureCall)featureCall.eContainer();
            if (container.isExplicitStatic()) {
                return true;
            }
            return this.isDefiniteTypeLiteral(container);
        }
        return false;
    }
}

