/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public interface IFacetedProject
extends IFacetedProjectBase {
    public IProjectFacetVersion getInstalledVersion(IProjectFacet var1);

    public void installProjectFacet(IProjectFacetVersion var1, Object var2, IProgressMonitor var3) throws CoreException;

    public void uninstallProjectFacet(IProjectFacetVersion var1, Object var2, IProgressMonitor var3) throws CoreException;

    public void modify(Set<Action> var1, IProgressMonitor var2) throws CoreException;

    public void setFixedProjectFacets(Set<IProjectFacet> var1) throws CoreException;

    public IRuntime getRuntime();

    public void setRuntime(IRuntime var1, IProgressMonitor var2) throws CoreException;

    public void setTargetedRuntimes(Set<IRuntime> var1, IProgressMonitor var2) throws CoreException;

    public void addTargetedRuntime(IRuntime var1, IProgressMonitor var2) throws CoreException;

    public void removeTargetedRuntime(IRuntime var1, IProgressMonitor var2) throws CoreException;

    public void setPrimaryRuntime(IRuntime var1, IProgressMonitor var2) throws CoreException;

    public IFacetedProjectWorkingCopy createWorkingCopy();

    public IMarker createErrorMarker(String var1) throws CoreException;

    public IMarker createErrorMarker(String var1, String var2) throws CoreException;

    public IMarker createWarningMarker(String var1) throws CoreException;

    public IMarker createWarningMarker(String var1, String var2) throws CoreException;

    public void addListener(IFacetedProjectListener var1);

    public void removeListener(IFacetedProjectListener var1);

    public Preferences getPreferences(IProjectFacet var1) throws BackingStoreException;

    public static final class Action {
        private final Type type;
        private final IProjectFacetVersion fv;
        private final Object config;

        public Action(Type type, IProjectFacetVersion fv, Object config) {
            if (type == null || fv == null) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            this.fv = fv;
            this.config = config;
        }

        public Type getType() {
            return this.type;
        }

        public IProjectFacetVersion getProjectFacetVersion() {
            return this.fv;
        }

        public Object getConfig() {
            return this.config;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Action)) {
                return false;
            }
            Action action = (Action)obj;
            return this.type == action.type && this.fv.equals(action.fv);
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.fv.hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.type.toString());
            buf.append('[');
            buf.append(this.fv.getProjectFacet().getId());
            buf.append(' ');
            buf.append(this.fv.getVersionString());
            buf.append(']');
            return buf.toString();
        }

        public static final class Type {
            private static final Map<String, Type> items = new HashMap<String, Type>();
            public static final Type INSTALL = new Type("INSTALL");
            public static final Type UNINSTALL = new Type("UNINSTALL");
            public static final Type VERSION_CHANGE = new Type("VERSION_CHANGE");
            private final String name;

            static {
                items.put("install", INSTALL);
                items.put("uninstall", UNINSTALL);
                items.put("version-change", VERSION_CHANGE);
            }

            private Type(String name) {
                this.name = name;
                items.put(name, this);
            }

            public static Type valueOf(String name) {
                return items.get(name);
            }

            public String name() {
                return this.name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

