/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpOptions;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ModuleImportsCleanUpCore
extends AbstractCleanUp {
    public ModuleImportsCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public ModuleImportsCleanUpCore() {
    }

    @Override
    public void setOptions(CleanUpOptions options) {
        super.setOptions(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), this.requireAST(), false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.module_imports");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        if (!this.isEnabled("cleanup.module_imports")) {
            return null;
        }
        if (!JavaModelUtil.is25OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        return this.createCleanUp(compilationUnit);
    }

    private ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        if (compilationUnit != null) {
            if (compilationUnit.getPackage() == null) {
                return null;
            }
            final IPackageBinding packageBinding = compilationUnit.getPackage().resolveBinding();
            if (packageBinding == null) {
                return null;
            }
            ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
            final IJavaProject project = cu.getJavaProject();
            IModuleBinding moduleBinding = packageBinding.getModule();
            if (moduleBinding == null) {
                return null;
            }
            final IModuleBinding[] requiredModules = moduleBinding.getRequiredModules();
            ArrayList<IModuleBinding> moduleImports = new ArrayList<IModuleBinding>();
            final ArrayList<String> neededImports = new ArrayList<String>();
            final HashMap typeList = new HashMap();
            final HashMap conflictList = new HashMap();
            ASTVisitor typeVisitor = new ASTVisitor(){

                public boolean visit(SimpleName node) {
                    if (node.getParent().getNodeType() != 40 && node.getParent().getNodeType() != 88) {
                        IBinding binding = node.resolveBinding();
                        if (binding instanceof ITypeBinding) {
                            IPackageBinding pkgBinding;
                            ITypeBinding typeBinding = (ITypeBinding)binding;
                            if (typeBinding.isParameterizedType()) {
                                typeBinding = typeBinding.getTypeDeclaration();
                            }
                            if (this.findTypeInModules(typeBinding) == ModuleTypeStatus.NOT_FOUND && (pkgBinding = typeBinding.getPackage()) != null && !pkgBinding.getName().equals("java.lang") && !pkgBinding.getName().equals(packageBinding.getName())) {
                                neededImports.add(typeBinding.getQualifiedName());
                            }
                        } else if (binding == null) {
                            throw new AbortSearchException();
                        }
                    }
                    return false;
                }

                private ModuleTypeStatus findTypeInModules(ITypeBinding binding) {
                    ModuleTypeStatus result = ModuleTypeStatus.NOT_FOUND;
                    IModuleBinding[] iModuleBindingArray = requiredModules;
                    int n = requiredModules.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModuleBinding requiredModule = iModuleBindingArray[n2];
                        for (IPackageBinding pkgBinding : ImportRewrite.getPackageBindingsForModule((IModuleBinding)requiredModule, (IJavaProject)project)) {
                            ArrayList<IModuleBinding> modules;
                            if (pkgBinding.findTypeBinding(binding.getName()) == null) continue;
                            if (!binding.getQualifiedName().startsWith(pkgBinding.getName())) {
                                result = ModuleTypeStatus.FOUND_CONFLICT;
                                HashSet<String> importSet = (HashSet<String>)conflictList.get(requiredModule);
                                if (importSet == null) {
                                    importSet = new HashSet<String>();
                                }
                                importSet.add(binding.getQualifiedName());
                                conflictList.put(requiredModule, importSet);
                                continue;
                            }
                            if (result == ModuleTypeStatus.NOT_FOUND) {
                                result = ModuleTypeStatus.FOUND_NO_CONFLICT;
                            }
                            if ((modules = (ArrayList<IModuleBinding>)typeList.get(binding.getQualifiedName())) == null) {
                                modules = new ArrayList<IModuleBinding>();
                            }
                            if (!modules.contains(requiredModule)) {
                                modules.add(requiredModule);
                            }
                            typeList.put(binding.getQualifiedName(), modules);
                        }
                        ++n2;
                    }
                    return result;
                }

                static enum ModuleTypeStatus {
                    NOT_FOUND,
                    FOUND_NO_CONFLICT,
                    FOUND_CONFLICT;

                }
            };
            try {
                compilationUnit.accept(typeVisitor);
            }
            catch (AbortSearchException e) {
                return null;
            }
            for (Map.Entry conflictEntry : conflictList.entrySet()) {
                int conflictNeededCount = 0;
                for (Map.Entry typeListEntry : typeList.entrySet()) {
                    if (((List)typeListEntry.getValue()).size() != 1 || !((List)typeListEntry.getValue()).contains(conflictEntry.getKey())) continue;
                    ++conflictNeededCount;
                }
                if (conflictNeededCount < ((Set)conflictEntry.getValue()).size()) {
                    for (Map.Entry typeListEntry2 : typeList.entrySet()) {
                        ((List)typeListEntry2.getValue()).remove(conflictEntry.getKey());
                    }
                    continue;
                }
                for (String name : (Set)conflictEntry.getValue()) {
                    neededImports.add(name);
                }
            }
            for (String typeListName : typeList.keySet()) {
                if (neededImports.contains(typeListName)) continue;
                if (!((List)typeList.get(typeListName)).isEmpty()) {
                    moduleImports.add((IModuleBinding)((List)typeList.get(typeListName)).get(0));
                    continue;
                }
                neededImports.add(typeListName);
            }
            return new CreateModuleImportsFix(compilationUnit, moduleImports, neededImports);
        }
        return null;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.module_imports")) {
            result.add(MultiFixMessages.ModuleImportsCleanup_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (!this.isEnabled("cleanup.module_imports")) {
            return "import java.util.List;\nimport java.util.ArrayList;\n";
        }
        return "import module java.base;\n";
    }

    public class CreateModuleImportsFix
    implements ICleanUpFix {
        private final CompilationUnit fCompilationUnit;
        private final List<IModuleBinding> fModuleImports;
        private final List<String> fNeededImports;
        private static ImportRewrite.ImportRewriteContext UNRESOLVABLE_IMPORT_CONTEXT = new ImportRewrite.ImportRewriteContext(){

            public int findInContext(String qualifier, String name, int kind) {
                return 4;
            }
        };

        public CreateModuleImportsFix(CompilationUnit cu, List<IModuleBinding> moduleImports, List<String> neededImports) {
            this.fCompilationUnit = cu;
            this.fModuleImports = moduleImports;
            this.fNeededImports = neededImports;
        }

        @Override
        public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
            ImportRewrite importRewrite = ImportRewrite.create((CompilationUnit)this.fCompilationUnit, (boolean)true);
            List importDecls = this.fCompilationUnit.imports();
            for (ImportDeclaration importDecl : importDecls) {
                if (Modifier.isModule((int)importDecl.getModifiers())) {
                    boolean found = false;
                    for (IModuleBinding moduleImport : this.fModuleImports) {
                        if (!moduleImport.getName().equals(importDecl.getName().getFullyQualifiedName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    importRewrite.removeModuleImport(importDecl.getName().getFullyQualifiedName());
                    continue;
                }
                if (importDecl.isStatic()) continue;
                if (importDecl.isOnDemand()) {
                    for (IModuleBinding moduleImport : this.fModuleImports) {
                        for (String pkgName : ImportRewrite.getPackageNamesForModule((IModuleBinding)moduleImport, (IJavaProject)this.fCompilationUnit.getJavaElement().getJavaProject())) {
                            if (!importDecl.getName().getFullyQualifiedName().equals(pkgName)) continue;
                            importRewrite.removeImport(importDecl.getName().getFullyQualifiedName() + ".*");
                        }
                    }
                    continue;
                }
                if (this.fNeededImports.contains(importDecl.getName().getFullyQualifiedName())) continue;
                importRewrite.removeImport(importDecl.getName().getFullyQualifiedName());
            }
            for (IModuleBinding moduleImport : this.fModuleImports) {
                importRewrite.addModuleImport(moduleImport.getName(), moduleImport);
            }
            for (String neededImport : this.fNeededImports) {
                importRewrite.addImport(neededImport, UNRESOLVABLE_IMPORT_CONTEXT);
            }
            CompilationUnitChange result = new CompilationUnitChange(MultiFixMessages.ModuleImportsCleanup_description, (ICompilationUnit)this.fCompilationUnit.getJavaElement());
            MultiTextEdit root = new MultiTextEdit();
            result.setEdit((TextEdit)root);
            TextEdit importEdit = importRewrite.rewriteImports(progressMonitor);
            root.addChild(importEdit);
            result.addTextEditGroup(new TextEditGroup(MultiFixMessages.ModuleImportsCleanup_description, new TextEdit[]{importEdit}));
            return result;
        }
    }
}

