/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;

final class BKDUtil {
    private BKDUtil() {
    }

    public static ArrayUtil.ByteArrayComparator getPrefixLengthComparator(int numBytes) {
        if (numBytes == 8) {
            return BKDUtil::commonPrefixLength8;
        }
        if (numBytes == 4) {
            return BKDUtil::commonPrefixLength4;
        }
        return (a, aOffset, b, bOffset) -> BKDUtil.commonPrefixLengthN(a, aOffset, b, bOffset, numBytes);
    }

    public static int commonPrefixLength8(byte[] a, int aOffset, byte[] b, int bOffset) {
        long aLong = BitUtil.VH_LE_LONG.get(a, aOffset);
        long bLong = BitUtil.VH_LE_LONG.get(b, bOffset);
        int commonPrefixInBits = Long.numberOfLeadingZeros(Long.reverseBytes(aLong ^ bLong));
        return commonPrefixInBits >>> 3;
    }

    public static int commonPrefixLength4(byte[] a, int aOffset, byte[] b, int bOffset) {
        int aInt = BitUtil.VH_LE_INT.get(a, aOffset);
        int bInt = BitUtil.VH_LE_INT.get(b, bOffset);
        int commonPrefixInBits = Integer.numberOfLeadingZeros(Integer.reverseBytes(aInt ^ bInt));
        return commonPrefixInBits >>> 3;
    }

    static int commonPrefixLengthN(byte[] a, int aOffset, byte[] b, int bOffset, int numBytes) {
        int cmp = Arrays.mismatch(a, aOffset, aOffset + numBytes, b, bOffset, bOffset + numBytes);
        if (cmp == -1) {
            return numBytes;
        }
        return cmp;
    }

    public static ByteArrayPredicate getEqualsPredicate(int numBytes) {
        if (numBytes == 8) {
            return BKDUtil::equals8;
        }
        if (numBytes == 4) {
            return BKDUtil::equals4;
        }
        return (a, aOffset, b, bOffset) -> Arrays.equals(a, aOffset, aOffset + numBytes, b, bOffset, bOffset + numBytes);
    }

    public static boolean equals8(byte[] a, int aOffset, byte[] b, int bOffset) {
        long bLong;
        long aLong = BitUtil.VH_LE_LONG.get(a, aOffset);
        return aLong == (bLong = BitUtil.VH_LE_LONG.get(b, bOffset));
    }

    public static boolean equals4(byte[] a, int aOffset, byte[] b, int bOffset) {
        int bInt;
        int aInt = BitUtil.VH_LE_INT.get(a, aOffset);
        return aInt == (bInt = BitUtil.VH_LE_INT.get(b, bOffset));
    }

    @FunctionalInterface
    public static interface ByteArrayPredicate {
        public boolean test(byte[] var1, int var2, byte[] var3, int var4);
    }
}

