/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.model.application.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.InternalSideValue;

public enum SideValue implements InternalSideValue
{
    TOP(0, "Top", "Top"),
    BOTTOM(1, "Bottom", "Bottom"),
    LEFT(2, "Left", "Left"),
    RIGHT(3, "Right", "Right");

    public static final int TOP_VALUE = 0;
    public static final int BOTTOM_VALUE = 1;
    public static final int LEFT_VALUE = 2;
    public static final int RIGHT_VALUE = 3;
    private static final SideValue[] VALUES_ARRAY;
    public static final List<SideValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SideValue[]{TOP, BOTTOM, LEFT, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SideValue get(String literal) {
        SideValue[] sideValueArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            SideValue result = sideValueArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static SideValue getByName(String name) {
        SideValue[] sideValueArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            SideValue result = sideValueArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static SideValue get(int value) {
        switch (value) {
            case 0: {
                return TOP;
            }
            case 1: {
                return BOTTOM;
            }
            case 2: {
                return LEFT;
            }
            case 3: {
                return RIGHT;
            }
        }
        return null;
    }

    private SideValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

