/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.internal.ui.filtertable.Filter;
import org.eclipse.jdt.internal.ui.filtertable.JavaFilterTable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectImportsDialog
extends TitleAreaDialog {
    private JavaFilterTable fJavaFilterTable;
    private JavaSnippetEditor fEditor;

    public SelectImportsDialog(JavaSnippetEditor editor, final String[] imports) {
        super(editor.getShell());
        this.fEditor = editor;
        this.fJavaFilterTable = new JavaFilterTable(new JavaFilterTable.FilterStorage(){

            public Filter[] getStoredFilters(boolean defaults) {
                if (imports == null) {
                    return new Filter[0];
                }
                Filter[] result = new Filter[imports.length];
                int i = 0;
                while (i < imports.length) {
                    result[i] = new Filter(imports[i], true);
                    ++i;
                }
                return result;
            }

            public void setStoredFilters(IPreferenceStore store, Filter[] filters) {
                String[] newImports = new String[filters.length];
                int i = 0;
                while (i < filters.length) {
                    newImports[i] = filters[i].getName();
                    ++i;
                }
                SelectImportsDialog.this.fEditor.setImports(newImports);
            }
        }, new JavaFilterTable.FilterTableConfig().setAddType(new JavaFilterTable.ButtonLabel(SnippetMessages.getString("SelectImportsDialog.Add_&Type_1"), SnippetMessages.getString("SelectImportsDialog.Choose_a_Type_to_Add_as_an_Import_2"))).setAddPackage(new JavaFilterTable.ButtonLabel(SnippetMessages.getString("SelectImportsDialog.Add_&Package_3"), SnippetMessages.getString("SelectImportsDialog.Choose_a_Package_to_Add_as_an_Import_4"))).setRemove(new JavaFilterTable.ButtonLabel(SnippetMessages.getString("SelectImportsDialog.&Remove_5"), SnippetMessages.getString("SelectImportsDialog.Remove_All_Selected_Imports_6"))).setAddPackageDialog(new JavaFilterTable.DialogLabels(SnippetMessages.getString("SelectImportsDialog.Add_package_as_import_7"), SnippetMessages.getString("SelectImportsDialog.&Select_a_package_to_add_as_an_Import_10"))).setAddTypeDialog(new JavaFilterTable.DialogLabels(SnippetMessages.getString("SelectImportsDialog.Add_Type_as_Import_12"), SnippetMessages.getString("SelectImportsDialog.&Select_a_type_to_add_to_add_as_an_import_15"))).setConsiderAllTypes(true).setCheckable(false).setLabelText(SnippetMessages.getString("SelectImportsDialog.imports_heading")).setHelpContextId(IJavaDebugHelpContextIds.SNIPPET_IMPORTS_DIALOG)){

            protected IJavaSearchScope getTypeSearchScope() {
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{SelectImportsDialog.this.fEditor.getJavaProject()}, (boolean)true);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(NLS.bind((String)SnippetMessages.getString("SelectImportsDialog.Manage_the_Java_Snippet_Editor_Imports_for___{0}__1"), (Object)this.fEditor.getEditorInput().getName()));
        this.setMessage(NLS.bind((String)SnippetMessages.getString("SelectImportsDialog.add_remove_imports"), (Object)this.fEditor.getEditorInput().getName()));
        Composite outer = SWTFactory.createComposite((Composite)parent, (int)2, (int)1, (int)1808);
        GridLayout gl = (GridLayout)outer.getLayout();
        gl.marginLeft = 7;
        gl.marginTop = 0;
        gl.marginBottom = 0;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)outer, IJavaDebugHelpContextIds.SNIPPET_IMPORTS_DIALOG);
        this.fJavaFilterTable.createTable(outer);
        return parent;
    }

    protected void okPressed() {
        this.fJavaFilterTable.performOk(null);
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SnippetMessages.getString("SelectImportsDialog.Java_Snippet_Imports_18"));
    }
}

