/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class AutoUpdateQueryAction
extends BaseSelectionListenerAction {
    public AutoUpdateQueryAction() {
        super(Messages.AutoUpdateQueryAction_Synchronize_Automatically_Label);
        this.setChecked(false);
        this.setEnabled(false);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object element;
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof RepositoryQuery) {
            this.setChecked(((RepositoryQuery)element).getAutoUpdate());
            return true;
        }
        this.setChecked(false);
        return false;
    }

    public void run() {
        Object element = this.getStructuredSelection().getFirstElement();
        if (element instanceof RepositoryQuery) {
            try {
                RepositoryQuery query = (RepositoryQuery)element;
                TasksUiPlugin.getTaskList().run(monitor -> query.setAutoUpdate(this.isChecked()));
                TasksUiPlugin.getTaskList().notifyElementsChanged(Collections.singleton(query));
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to set offline status for query", (Throwable)e));
            }
        }
    }
}

